/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.tests.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class MockStateOfActiveResourceTupleDataSource
extends AbstractDataSource {
    private List<MeasuringValue> data = new ArrayList<MeasuringValue>();
    private final Amount<Duration> windowLength;
    private final MeasuringPoint point;
    private static final MetricSetDescription expectedInputDataMetric = MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE;
    private static final Measure<Long, Dimensionless> idleStateMeasure = Measure.valueOf((long)0L, (Unit)Unit.ONE);
    private static final Measure<Long, Dimensionless> busyStateMeasure = Measure.valueOf((long)42L, (Unit)Unit.ONE);

    public MockStateOfActiveResourceTupleDataSource(Measure<Double, Duration> windowLength, MeasuringPoint point) {
        this((Amount<Duration>)Amount.valueOf((double)windowLength.doubleValue(windowLength.getUnit()), (Unit)windowLength.getUnit()), point);
    }

    public MockStateOfActiveResourceTupleDataSource(Amount<Duration> windowLength, MeasuringPoint point) {
        super((MetricDescription)expectedInputDataMetric);
        this.windowLength = windowLength;
        this.point = point;
    }

    public void createData100PercentUtilization(Amount<Duration> intervalStart) {
        Measure pointInTimeMeasure = Measure.valueOf((double)intervalStart.doubleValue((Unit)SI.SECOND), (Unit)SI.SECOND);
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, busyStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)intervalStart.plus(this.windowLength.times(0.3)).doubleValue(SI.MILLI((Unit)SI.SECOND)), (Unit)SI.MILLI((Unit)SI.SECOND));
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, busyStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)intervalStart.plus(this.windowLength.times(0.8)).doubleValue(SI.CENTI((Unit)SI.SECOND)), (Unit)SI.CENTI((Unit)SI.SECOND));
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, busyStateMeasure}));
    }

    public void createData75PercentUtilization(Amount<Duration> intervalStart) {
        Measure pointInTimeMeasure = Measure.valueOf((double)intervalStart.doubleValue((Unit)SI.SECOND), (Unit)SI.SECOND);
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, busyStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)intervalStart.plus(this.windowLength.times(0.3)).doubleValue(SI.MILLI((Unit)SI.SECOND)), (Unit)SI.MILLI((Unit)SI.SECOND));
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, idleStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)intervalStart.plus(this.windowLength.times(0.55)).doubleValue(SI.CENTI((Unit)SI.SECOND)), (Unit)SI.CENTI((Unit)SI.SECOND));
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, busyStateMeasure}));
    }

    public void createData50PercentUtilization(Amount<Duration> intervalStart) {
        Measure pointInTimeMeasure = Measure.valueOf((double)intervalStart.doubleValue((Unit)SI.SECOND), (Unit)SI.SECOND);
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, busyStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)intervalStart.plus(this.windowLength.times(0.3)).doubleValue(SI.MILLI((Unit)SI.SECOND)), (Unit)SI.MILLI((Unit)SI.SECOND));
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, idleStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)intervalStart.plus(this.windowLength.times(0.8)).doubleValue(SI.CENTI((Unit)SI.SECOND)), (Unit)SI.CENTI((Unit)SI.SECOND));
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, busyStateMeasure}));
    }

    public void createData25PercentUtilization(Amount<Duration> intervalStart) {
        Measure pointInTimeMeasure = Measure.valueOf((double)intervalStart.doubleValue((Unit)SI.SECOND), (Unit)SI.SECOND);
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, busyStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)intervalStart.plus(this.windowLength.times(0.25)).doubleValue(SI.MILLI((Unit)SI.SECOND)), (Unit)SI.MILLI((Unit)SI.SECOND));
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, idleStateMeasure}));
    }

    public void createDataNoUtilization(Amount<Duration> intervalStart) {
        Measure pointInTimeMeasure = Measure.valueOf((double)intervalStart.doubleValue((Unit)SI.SECOND), (Unit)SI.SECOND);
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, idleStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)intervalStart.plus(this.windowLength.times(0.25)).doubleValue(SI.MILLI((Unit)SI.SECOND)), (Unit)SI.MILLI((Unit)SI.SECOND));
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, idleStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)intervalStart.plus(this.windowLength.times(0.75)).doubleValue(SI.CENTI((Unit)SI.SECOND)), (Unit)SI.CENTI((Unit)SI.SECOND));
        this.data.add((MeasuringValue)new TupleMeasurement(expectedInputDataMetric, new Measure[]{pointInTimeMeasure, idleStateMeasure}));
    }

    public <M extends IMeasureProvider> IDataStream<M> getDataStream() {
        return new IDataStream<M>(){

            public Iterator<M> iterator() {
                Iterator result = MockStateOfActiveResourceTupleDataSource.this.data.iterator();
                return result;
            }

            public MetricDescription getMetricDesciption() {
                return expectedInputDataMetric;
            }

            public boolean isCompatibleWith(MetricDescription other) {
                return this.getMetricDesciption().equals(other);
            }

            public void close() {
                MockStateOfActiveResourceTupleDataSource.this.data.clear();
            }

            public int size() {
                return MockStateOfActiveResourceTupleDataSource.this.data.size();
            }
        };
    }

    protected PropertyConfigurable createProperties() {
        return new PropertyConfigurable(){

            public Class<?> getPropertyType(String key) {
                return null;
            }

            public Set<String> getKeys() {
                return Collections.emptySet();
            }

            public Map<String, Object> getDefaultConfiguration() {
                return Collections.emptyMap();
            }
        };
    }

    public MeasuringPoint getMeasuringPoint() {
        return this.point;
    }
}

