/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.infrastructure.tests;

import de.fzi.power.infrastructure.InfrastructureFactory;
import de.fzi.power.infrastructure.InfrastructurePackage;
import de.fzi.power.infrastructure.PowerDistributionUnit;
import de.fzi.power.infrastructure.util.InfrastructureResourceFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;

public class InfrastructureExample {
    public static void main(String[] args) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new InfrastructureResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.fzi.de/Power/Infrastructure/1.0", (Object)InfrastructurePackage.eINSTANCE);
        if (args.length == 0) {
            System.out.println("Enter a list of file paths or URIs that have content like this:");
            try {
                Resource resource = resourceSet.createResource(URI.createURI((String)"http:///My.infrastructure"));
                PowerDistributionUnit root = InfrastructureFactory.eINSTANCE.createPowerDistributionUnit();
                resource.getContents().add((Object)root);
                resource.save((OutputStream)System.out, null);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                File file = new File(arg);
                URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)arg);
                try {
                    Resource resource = resourceSet.getResource(uri, true);
                    System.out.println("Loaded " + uri);
                    for (EObject eObject : resource.getContents()) {
                        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                        if (diagnostic.getSeverity() == 0) continue;
                        InfrastructureExample.printDiagnostic(diagnostic, "");
                    }
                }
                catch (RuntimeException exception) {
                    System.out.println("Problem loading " + uri);
                    exception.printStackTrace();
                }
                ++n2;
            }
        }
    }

    protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
        System.out.print(indent);
        System.out.println(diagnostic.getMessage());
        for (Diagnostic child : diagnostic.getChildren()) {
            InfrastructureExample.printDiagnostic(child, String.valueOf(indent) + "  ");
        }
    }
}

