/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.specification.tests;

import de.fzi.power.specification.PowerModelRepository;
import de.fzi.power.specification.SpecificationFactory;
import de.fzi.power.specification.SpecificationPackage;
import de.fzi.power.specification.util.SpecificationResourceFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;

public class SpecificationExample {
    public static void main(String[] args) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new SpecificationResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.fzi.de/Power/Specification/1.0", (Object)SpecificationPackage.eINSTANCE);
        if (args.length == 0) {
            System.out.println("Enter a list of file paths or URIs that have content like this:");
            try {
                Resource resource = resourceSet.createResource(URI.createURI((String)"http:///My.spec"));
                PowerModelRepository root = SpecificationFactory.eINSTANCE.createPowerModelRepository();
                resource.getContents().add((Object)root);
                resource.save((OutputStream)System.out, null);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                File file = new File(arg);
                URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)arg);
                try {
                    Resource resource = resourceSet.getResource(uri, true);
                    System.out.println("Loaded " + uri);
                    for (EObject eObject : resource.getContents()) {
                        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                        if (diagnostic.getSeverity() == 0) continue;
                        SpecificationExample.printDiagnostic(diagnostic, "");
                    }
                }
                catch (RuntimeException exception) {
                    System.out.println("Problem loading " + uri);
                    exception.printStackTrace();
                }
                ++n2;
            }
        }
    }

    protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
        System.out.print(indent);
        System.out.println(diagnostic.getMessage());
        for (Diagnostic child : diagnostic.getChildren()) {
            SpecificationExample.printDiagnostic(child, String.valueOf(indent) + "  ");
        }
    }
}

