/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators;

import de.fzi.power.binding.AbstractPowerStateBinding;
import de.fzi.power.binding.PowerStateBinding;
import de.fzi.power.binding.ResourcePowerBinding;
import de.fzi.power.binding.TransitionStateBinding;
import de.fzi.power.binding.util.BindingSwitch;
import de.fzi.power.infrastructure.PowerConsumingResourceSet;
import de.fzi.power.infrastructure.PowerProvidingEntity;
import de.fzi.power.infrastructure.StatefulPowerConsumingResourceSet;
import de.fzi.power.interpreter.calculators.AbstractDistributionPowerModelCalculator;
import de.fzi.power.interpreter.calculators.CalculatorFactory;
import de.fzi.power.interpreter.calculators.CalculatorInstantiator;
import de.fzi.power.interpreter.calculators.IResourcePowerModelCalculator;
import de.fzi.power.interpreter.calculators.ITimeProvider;
import de.fzi.power.interpreter.calculators.StatefulPowerConsumingResourceCalculator;
import de.fzi.power.interpreter.calculators.TransitionStatePowerModelCalculator;
import de.fzi.power.specification.PowerModelSpecification;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import javax.measure.quantity.Duration;
import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.EObject;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;

public class ExtensibleCalculatorInstantiatorImpl
implements CalculatorInstantiator {
    public static final String CALCULATOR_FACTORY_EXTENSION_POINT = "de.fzi.power.interpreter.calculators.calculatorfactory";
    private static final String CALCULATOR_FACTORY_ATTRIBUTE_NAME = "factory";
    private static final int DEFAULT_SIZE = 4;
    private static final String CALCULATOR_FACTORY_ELEMENT_NAME = "calculatorFactory";
    ITimeProvider timeProvider;
    protected final PriorityQueue<CalculatorFactory> factoryQueue = new PriorityQueue<CalculatorFactory>(4, new Comparator<CalculatorFactory>(){

        @Override
        public int compare(CalculatorFactory o1, CalculatorFactory o2) {
            return Integer.compare(o1.getPriority(), o2.getPriority());
        }
    });

    public ExtensibleCalculatorInstantiatorImpl() {
        this(new ITimeProvider(){

            @Override
            public Amount<Duration> getCurrentTime() {
                return Amount.valueOf((long)0L, (Unit)Duration.UNIT);
            }
        });
    }

    public ExtensibleCalculatorInstantiatorImpl(ITimeProvider provider) {
        this.timeProvider = provider;
        this.retrieveFactories();
    }

    private void retrieveFactories() {
        List factories = ExtensionHelper.getExecutableExtensions((String)CALCULATOR_FACTORY_EXTENSION_POINT, (String)CALCULATOR_FACTORY_ELEMENT_NAME, (String)CALCULATOR_FACTORY_ATTRIBUTE_NAME);
        this.factoryQueue.addAll(factories);
    }

    @Override
    public IResourcePowerModelCalculator instantiateResourceCalculator(PowerConsumingResourceSet resource) {
        return this.instantiateResourceCalculator(resource.getResourcePowerAssemblyContext());
    }

    protected IResourcePowerModelCalculator instantiateResourceCalculator(ResourcePowerBinding binding) {
        for (CalculatorFactory factory : this.factoryQueue) {
            if (!factory.isCompatibleWith((PowerModelSpecification)binding.getResourcePowerModelSpecification())) continue;
            return factory.instantiateResourcePowerModelCalculator(binding);
        }
        throw new IllegalArgumentException("The passed ResourcePowerAssemblyContext refers to an unknown power model.");
    }

    @Override
    public AbstractDistributionPowerModelCalculator instantiatePowerProvidingEntityCalculator(PowerProvidingEntity ppe) {
        for (CalculatorFactory factory : this.factoryQueue) {
            if (!factory.isCompatibleWith((PowerModelSpecification)ppe.getDistributionPowerAssemblyContext().getDistributionPowerModel())) continue;
            return factory.instantiateDistributionPowerModelCalculator(ppe.getDistributionPowerAssemblyContext());
        }
        throw new IllegalArgumentException("The passed PowerProvidingEntity refers to an unknown power model.");
    }

    @Override
    public IResourcePowerModelCalculator instantiateStatefulResourcePowerModelCalculator(final StatefulPowerConsumingResourceSet resource) {
        final HashMap<AbstractPowerStateBinding, IResourcePowerModelCalculator> powerCalculatorsPerState = new HashMap<AbstractPowerStateBinding, IResourcePowerModelCalculator>();
        for (AbstractPowerStateBinding curStateBinding : resource.getStatefulResourcePowerBinding().getPowerStateBindings()) {
            new BindingSwitch<Void>(){

                public Void casePowerStateBinding(PowerStateBinding state) {
                    ResourcePowerBinding binding = state.getBinding();
                    powerCalculatorsPerState.put(state, ExtensibleCalculatorInstantiatorImpl.this.instantiateResourceCalculator(binding));
                    return null;
                }

                public Void caseTransitionStateBinding(TransitionStateBinding state) {
                    powerCalculatorsPerState.put(state, new TransitionStatePowerModelCalculator(resource, state, ExtensibleCalculatorInstantiatorImpl.this.timeProvider));
                    return null;
                }
            }.doSwitch((EObject)curStateBinding);
        }
        return new StatefulPowerConsumingResourceCalculator(resource, powerCalculatorsPerState);
    }
}

