/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.ui.adapters;

import de.fzi.power.binding.PowerBindingRepository;
import de.fzi.power.infrastructure.PowerProvidingEntity;
import de.fzi.power.interpreter.AbstractEvaluationScope;
import de.fzi.power.interpreter.ConsumptionContext;
import de.fzi.power.interpreter.EvaluationScope;
import de.fzi.power.interpreter.InterpreterUtils;
import de.fzi.power.interpreter.PowerConsumptionSwitch;
import de.fzi.power.interpreter.PowerModelRegistry;
import de.fzi.power.interpreter.PowerModelUpdaterSwitch;
import de.fzi.power.interpreter.calculators.CalculatorInstantiator;
import de.fzi.power.interpreter.calculators.ExtensibleCalculatorInstantiatorImpl;
import de.fzi.power.interpreter.measureprovider.ExtendedMeasureProvider;
import de.fzi.power.interpreter.measureprovider.MeasureProviderHelper;
import de.fzi.power.ui.adapters.NestedPropertyConfigurableConfiguration;
import de.uka.ipd.sdq.identifier.Identifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IPersistableElement;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyListener;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.StringMeasuringPoint;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;

public class AnalysisPowerConsumptionAdapter
extends AbstractDataSource
implements IPersistable,
IPersistableElement,
IPropertyListener {
    private static final MetricSetDescription FILTER_OUTPUT_METRIC = MetricDescriptionConstants.POWER_CONSUMPTION_TUPLE;
    private static final MetricSetDescription STATE_OF_ACTIVE_RESOURCE_METRIC = MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE;
    private static final MetricSetDescription OVERALL_UTILIZATION_METRIC = MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE;
    private final PowerModelRegistry registry = new PowerModelRegistry();
    private final PowerModelUpdaterSwitch modelUpdaterSwitch = new PowerModelUpdaterSwitch(this.registry, (CalculatorInstantiator)new ExtensibleCalculatorInstantiatorImpl());
    private Set<ExtendedMeasureProvider> extendedMeasureProviders;
    private Optional<PowerProvidingEntity> powerProvidingEntity = Optional.empty();
    private Optional<ExperimentRun> experimentRun = Optional.empty();
    private Optional<MeasuringPoint> measuringPoint = Optional.empty();
    private Optional<Collection<MeasuringValue>> evaluatedPowerMeasurements = Optional.empty();

    public AnalysisPowerConsumptionAdapter() {
        super((MetricDescription)FILTER_OUTPUT_METRIC);
    }

    private static Collection<IDataSource> collectScopeDataSources(Set<ProcessingResourceSpecification> processingResourceSpecs, ExperimentRun experimentRun) {
        List processingResourceSpecIds = processingResourceSpecs.stream().collect(Collectors.mapping(Identifier::getId, Collectors.toList()));
        return experimentRun.getMeasurement().stream().filter(m -> AnalysisPowerConsumptionAdapter.isDataSource(m, processingResourceSpecIds)).map(Measurement::getMeasurementRanges).map(ranges -> (MeasurementRange)ranges.get(0)).map(MeasurementRange::getRawMeasurements).map(Edp2DataTupleDataSource::new).collect(Collectors.toList());
    }

    private static boolean isDataSource(Measurement measurement, List<String> processingResourceSpecIds) {
        MeasuringType type = measurement.getMeasuringType();
        boolean result = true;
        ProcessingResourceSpecification correspondingProcessingResourceSpecification = InterpreterUtils.getProcessingResourceSpecificationFromMeasuringPoint((MeasuringPoint)type.getMeasuringPoint());
        if (correspondingProcessingResourceSpecification == null || !processingResourceSpecIds.contains(correspondingProcessingResourceSpecification.getId())) {
            result = false;
        } else {
            MetricDescription measurementMetric = type.getMetric();
            if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)OVERALL_UTILIZATION_METRIC, (MetricDescription)measurementMetric)) {
                result = correspondingProcessingResourceSpecification.getNumberOfReplicas() > 1 && !AnalysisPowerConsumptionAdapter.isTagged((EMap<String, Object>)measurement.getAdditionalInformation());
            } else if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)STATE_OF_ACTIVE_RESOURCE_METRIC, (MetricDescription)measurementMetric)) {
                result = correspondingProcessingResourceSpecification.getNumberOfReplicas() == 1;
            }
        }
        return result;
    }

    private static boolean isTagged(EMap<String, Object> measInfo) {
        return measInfo.containsKey((Object)"SLIDING_WINDOW_BASED") && Boolean.logicalAnd(MeasurementsUtility.SLIDING_WINDOW_BASED_MEASUREMENT_TAG_VALUE, Boolean.valueOf(measInfo.get((Object)"SLIDING_WINDOW_BASED").toString()));
    }

    public MeasuringPoint getMeasuringPoint() {
        return this.powerProvidingEntity.map(ppe -> this.measuringPoint.orElse(this.createMeasuringPoint())).orElse(null);
    }

    private MeasuringPoint createMeasuringPoint() {
        assert (this.powerProvidingEntity.isPresent());
        String ppeName = this.powerProvidingEntity.get().getName();
        StringMeasuringPoint mp = MeasuringpointFactory.eINSTANCE.createStringMeasuringPoint();
        mp.setMeasuringPoint(ppeName == null ? "" : ppeName);
        mp.setStringRepresentation(mp.getMeasuringPoint());
        return mp;
    }

    private Collection<MeasuringValue> obtainPowerConsumptionMeasurements(PowerBindingRepository bindingRepo, Iterable<IDataSource> scopeDataSources) {
        assert (this.powerProvidingEntity.isPresent());
        ArrayList<MeasuringValue> result = new ArrayList<MeasuringValue>();
        this.modelUpdaterSwitch.doSwitch((EObject)this.powerProvidingEntity.get());
        EvaluationScope scope = EvaluationScope.createScope(scopeDataSources, this.extendedMeasureProviders);
        ConsumptionContext context = ConsumptionContext.createConsumptionContext((PowerBindingRepository)bindingRepo, (AbstractEvaluationScope)scope, (PowerModelRegistry)this.registry);
        PowerConsumptionSwitch consumptionSwitch = PowerConsumptionSwitch.createPowerConsumptionSwitch((ConsumptionContext)context);
        while (scope.hasNext()) {
            scope.next();
            Amount powerAmount = (Amount)consumptionSwitch.doSwitch((EObject)this.powerProvidingEntity.get());
            Measure powerMeasure = Measure.valueOf((double)powerAmount.doubleValue((Unit)SI.WATT), (Unit)SI.WATT);
            Measure pointInTime = scope.getCurrentPointInTime();
            result.add((MeasuringValue)new TupleMeasurement(FILTER_OUTPUT_METRIC, new Measure[]{pointInTime, powerMeasure}));
        }
        context.cleanUp();
        return result;
    }

    public IDataStream<MeasuringValue> getDataStream() {
        ExperimentRun run = this.experimentRun.orElseThrow(() -> new IllegalArgumentException("Power consumption can only be analyzed with regards to an experiment run. Thus, this expRun must not be null."));
        PowerProvidingEntity ppe = this.powerProvidingEntity.orElseThrow(() -> new IllegalStateException("PowerProvidingEntity has not been set yet!"));
        if (!this.evaluatedPowerMeasurements.isPresent()) {
            this.evaluatedPowerMeasurements = Optional.of(this.obtainPowerConsumptionMeasurements(ppe.getDistributionPowerAssemblyContext().getPowerBindingRepository(), AnalysisPowerConsumptionAdapter.collectScopeDataSources(InterpreterUtils.getProcessingResourceSpecsFromInfrastructureElement((EObject)ppe), run)));
        }
        return new IDataStream<MeasuringValue>(){

            public boolean isCompatibleWith(MetricDescription other) {
                return this.getMetricDesciption().equals(other);
            }

            public MetricDescription getMetricDesciption() {
                return FILTER_OUTPUT_METRIC;
            }

            public Iterator<MeasuringValue> iterator() {
                return AnalysisPowerConsumptionAdapter.this.evaluatedPowerMeasurements.get().iterator();
            }

            public int size() {
                return AnalysisPowerConsumptionAdapter.this.evaluatedPowerMeasurements.get().size();
            }

            public void close() {
            }
        };
    }

    public void setPowerProvidingEntity(PowerProvidingEntity powerProvidingEntity) {
        this.powerProvidingEntity = Optional.of(Objects.requireNonNull(powerProvidingEntity, "PowerProvidingEntity must not be null."));
        this.resetAdapter();
    }

    public void setExperimentRun(ExperimentRun experimentRun) {
        this.experimentRun = Optional.of(Objects.requireNonNull(experimentRun, "ExperimentRun must not be null."));
        this.resetAdapter();
    }

    private void resetAdapter() {
        this.evaluatedPowerMeasurements = Optional.empty();
        this.measuringPoint = Optional.empty();
    }

    public String getFactoryId() {
        return null;
    }

    public void saveState(IMemento memento) {
    }

    protected PropertyConfigurable createProperties() {
        if (this.extendedMeasureProviders == null) {
            this.extendedMeasureProviders = new HashSet<ExtendedMeasureProvider>(Arrays.asList(MeasureProviderHelper.getMeasureProviderExtensions()));
        }
        NestedPropertyConfigurableConfiguration properties = new NestedPropertyConfigurableConfiguration(this.extendedMeasureProviders);
        properties.addObserver((Object)this);
        return properties;
    }

    public void propertyChangeCompleted() {
        this.evaluatedPowerMeasurements = Optional.empty();
    }

    public void propertyChanged(String key, Object oldValue, Object newValue) {
    }
}

