/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.Parser;
import org.vedantatree.expressionoasis.config.ConfigFactory;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionFactory;
import org.vedantatree.expressionoasis.grammar.ExpressionToken;
import org.vedantatree.expressionoasis.grammar.Grammar;

public class Compiler {
    private static Log LOGGER = LogFactory.getLog(Compiler.class);
    private final Grammar grammar;
    private final Parser parser;
    private final boolean expressionCachingEnabled;
    private final Map<String, Stack<ExpressionToken>> compiledExpressionRPNTokenCache;

    public Compiler() {
        this(ConfigFactory.getConfig().getGrammar());
    }

    public Compiler(Grammar grammar) {
        if (grammar == null) {
            throw new IllegalArgumentException("Grammar must not be null for the parser.");
        }
        this.grammar = grammar;
        this.parser = new Parser(grammar);
        this.expressionCachingEnabled = ConfigFactory.getConfig().shouldCacheCompiledExpressions();
        LOGGER.debug((Object)("expression-caching-enabled[" + this.expressionCachingEnabled + "]"));
        this.compiledExpressionRPNTokenCache = this.expressionCachingEnabled ? new HashMap() : null;
    }

    Grammar getGrammar() {
        return this.grammar;
    }

    protected Stack<ExpressionToken> getTokensInRPN(String expression) throws ExpressionEngineException {
        Stack<ExpressionToken> tokensInRPN = null;
        if (this.expressionCachingEnabled) {
            tokensInRPN = this.compiledExpressionRPNTokenCache.get(expression);
        }
        if (tokensInRPN == null) {
            List<ExpressionToken> expressionTokens = this.parser.parse(expression);
            tokensInRPN = this.restructureTokensInRPN(expressionTokens);
            if (this.expressionCachingEnabled) {
                this.compiledExpressionRPNTokenCache.put(expression, tokensInRPN);
            }
        }
        return tokensInRPN;
    }

    private Stack<ExpressionToken> restructureTokensInRPN(List<ExpressionToken> expressionTokensList) throws ExpressionEngineException {
        Stack<ExpressionToken> operatorStack = new Stack<ExpressionToken>();
        Stack<ExpressionToken> rpnStack = new Stack<ExpressionToken>();
        ExpressionToken lastToken = null;
        for (ExpressionToken currentToken : expressionTokensList) {
            if (this.grammar.isOperator(currentToken)) {
                if (operatorStack.isEmpty() && rpnStack.isEmpty()) {
                    operatorStack.push(new UnaryToken(currentToken));
                } else if (this.grammar.isOperator(lastToken) || this.grammar.isLeftBracket(lastToken)) {
                    operatorStack.push(new UnaryToken(currentToken));
                } else {
                    LOGGER.debug((Object)("currentTokenPP[" + currentToken + "]"));
                    int currentTokenPrecedence = this.grammar.getPrecedenceOrder(currentToken, this.isUnary(currentToken));
                    while (!operatorStack.isEmpty()) {
                        ExpressionToken peekToken = (ExpressionToken)operatorStack.peek();
                        if (!this.grammar.isOperator(peekToken) || currentTokenPrecedence > this.grammar.getPrecedenceOrder(peekToken, this.isUnary(peekToken))) break;
                        operatorStack.pop();
                        rpnStack.push(peekToken);
                    }
                    operatorStack.push(currentToken);
                }
            } else if (this.grammar.isBracket(currentToken)) {
                if (this.grammar.isLeftBracket(currentToken)) {
                    operatorStack.push(currentToken);
                } else {
                    boolean leftBracketFound = false;
                    while (!operatorStack.isEmpty()) {
                        ExpressionToken peekOperator = (ExpressionToken)operatorStack.peek();
                        leftBracketFound = this.grammar.isLeftBracket(peekOperator);
                        operatorStack.pop();
                        if (leftBracketFound) {
                            String value = String.valueOf(peekOperator.getValue()) + this.grammar.getOppositeBracket(peekOperator.getValue());
                            ExpressionToken bracketToken = this.grammar.isUnary(value) ? new UnaryToken(value, peekOperator.getIndex()) : new ExpressionToken(value, peekOperator.getIndex());
                            rpnStack.push(bracketToken);
                            break;
                        }
                        rpnStack.push(peekOperator);
                    }
                    if (!leftBracketFound) {
                        throw new ExpressionEngineException("Left bracket is missing for \"" + currentToken.getValue() + "\" at " + currentToken.getIndex());
                    }
                }
            } else {
                rpnStack.push(currentToken);
            }
            lastToken = currentToken;
        }
        while (!operatorStack.isEmpty()) {
            ExpressionToken element = (ExpressionToken)operatorStack.peek();
            if (this.grammar.isLeftBracket(element.getValue())) {
                throw new ExpressionEngineException("Right bracket is missing for \"" + element.getValue() + "\" at " + element.getIndex());
            }
            operatorStack.pop();
            rpnStack.push(element);
        }
        return rpnStack;
    }

    public Expression compile(String expression, ExpressionContext expressionContext, boolean validate) throws ExpressionEngineException {
        Stack<ExpressionToken> rpnTokens = this.getTokensInRPN(expression);
        Stack<Expression> expressionStack = new Stack<Expression>();
        int size = rpnTokens.size();
        int i = 0;
        while (i < size) {
            ExpressionToken token = (ExpressionToken)rpnTokens.get(i);
            String type = "operand";
            Expression[] initializationParameters = token.getValue();
            if (this.grammar.isOperator(token)) {
                if (this.isUnary(token)) {
                    type = this.grammar.isFunction(token.getValue()) ? "function" : "unary";
                    initializationParameters = expressionStack.size() == 0 ? null : expressionStack.pop();
                } else {
                    if (expressionStack.size() < 2) {
                        throw new ExpressionEngineException("Something wrong while compiling expression, as expression stack has less than 2 expression in case of binray expression. expressionStack[" + expressionStack + "]");
                    }
                    type = "binary";
                    Expression rightExpression = (Expression)expressionStack.pop();
                    Expression leftExpression = (Expression)expressionStack.pop();
                    initializationParameters = new Expression[]{leftExpression, rightExpression};
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("token[" + token + "]"));
            }
            Expression compiledExpression = ExpressionFactory.getInstance().createExpression(token.getValue(), type);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("expression[" + compiledExpression + "]"));
            }
            expressionContext.setContextProperty("TOKEN", token.getValue());
            compiledExpression.initialize(expressionContext, initializationParameters, validate);
            expressionContext.setContextProperty("TOKEN", null);
            expressionStack.push(compiledExpression);
            ++i;
        }
        if (expressionStack.size() != 1) {
            throw new ExpressionEngineException("Unable to compile expression. Expression Stack size should be one here. expressionStackSize[" + expressionStack.size() + "] rpnTokens[" + rpnTokens + "]");
        }
        return (Expression)expressionStack.peek();
    }

    private boolean isUnary(ExpressionToken token) {
        return token instanceof UnaryToken || this.grammar.isFunction(token);
    }

    private List<ExpressionToken> resolveUnaryOperator(List<ExpressionToken> tokenList) throws ExpressionEngineException {
        boolean wasOperator = true;
        int length = tokenList.size();
        int i = 0;
        while (i < length) {
            ExpressionToken token = tokenList.get(i);
            if (this.grammar.isOperator(token.getValue())) {
                if (wasOperator) {
                    if (!this.grammar.isUnary(token.getValue())) {
                        throw new ExpressionEngineException("The operator \"" + token.getValue() + "\" can't be used unary at " + token.getIndex());
                    }
                    tokenList.set(i, new UnaryToken(token));
                }
                wasOperator = true;
            } else {
                wasOperator = this.grammar.isLeftBracket(token.getValue());
            }
            ++i;
        }
        return tokenList;
    }

    private class UnaryToken
    extends ExpressionToken {
        public UnaryToken(ExpressionToken token) {
            this(token.getValue(), token.getIndex());
        }

        public UnaryToken(String value, int index) {
            super(value, index);
        }

        @Override
        public String toString() {
            return "{u:" + this.getValue() + ", " + this.getIndex() + "}";
        }
    }
}

