/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions;

import java.util.LinkedHashSet;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;

public class ExpressionTypeFinder
implements ExpressionVisitor {
    private final Expression expressionToSearch;
    private final Class expressionTypeToFind;
    private final LinkedHashSet<Expression> foundExpressions;

    public ExpressionTypeFinder(Expression expressionToSearch, Class expressionTypeToFind) {
        if (expressionToSearch == null) {
            throw new IllegalArgumentException("expressionToSearch must not be null");
        }
        if (expressionTypeToFind == null) {
            throw new IllegalArgumentException("expressionTypeToFind must not be null");
        }
        if (!Expression.class.isAssignableFrom(expressionTypeToFind)) {
            throw new IllegalArgumentException("expressionTypeToFind must be an Expression class");
        }
        this.expressionTypeToFind = expressionTypeToFind;
        this.expressionToSearch = expressionToSearch;
        this.foundExpressions = new LinkedHashSet();
    }

    @Override
    public void visit(Expression expression) {
        if (expression.getClass().equals(this.expressionTypeToFind)) {
            this.foundExpressions.add(expression);
        }
    }

    public LinkedHashSet<Expression> getExpressions() {
        this.expressionToSearch.accept(this);
        return this.foundExpressions;
    }
}

