/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions;

import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class NumericExpression
implements Expression {
    private ValueObject longValue;

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        return this.longValue;
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        return Type.LONG;
    }

    @Override
    public void initialize(ExpressionContext expressionContext, Object parameters, boolean validate) throws ExpressionEngineException {
        Long value = new Long((String)parameters);
        this.longValue = new ValueObject(value, Type.LONG);
    }

    @Override
    public void uninitialize(ExpressionContext expressionContext) {
        this.longValue = null;
    }

    public String toString() {
        return this.longValue == null ? "not-initialized-null-value" : this.longValue.getValue().toString();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

