/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.relational;

import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class GTEExpression
extends BinaryOperatorExpression {
    static {
        GTEExpression.addTypePair(GTEExpression.class, Type.LONG, Type.LONG, Type.BOOLEAN);
        GTEExpression.addTypePair(GTEExpression.class, Type.DOUBLE, Type.DOUBLE, Type.BOOLEAN);
        GTEExpression.addTypePair(GTEExpression.class, Type.LONG, Type.DOUBLE, Type.BOOLEAN);
        GTEExpression.addTypePair(GTEExpression.class, Type.DOUBLE, Type.LONG, Type.BOOLEAN);
        GTEExpression.addTypePair(GTEExpression.class, Type.OBJECT, Type.OBJECT, Type.BOOLEAN);
        GTEExpression.addTypePair(GTEExpression.class, Type.LONG, Type.OBJECT, Type.BOOLEAN);
        GTEExpression.addTypePair(GTEExpression.class, Type.OBJECT, Type.LONG, Type.BOOLEAN);
        GTEExpression.addTypePair(GTEExpression.class, Type.DOUBLE, Type.OBJECT, Type.BOOLEAN);
        GTEExpression.addTypePair(GTEExpression.class, Type.OBJECT, Type.DOUBLE, Type.BOOLEAN);
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Type leftType = this.leftOperandExpression.getReturnType();
        Type rightType = this.rightOperandExpression.getReturnType();
        Object leftValue = this.leftOperandExpression.getValue().getValue();
        Object rightValue = this.rightOperandExpression.getValue().getValue();
        ValueObject result = null;
        if (leftType == Type.OBJECT && rightType == Type.OBJECT) {
            result = new ValueObject(null, Type.BOOLEAN);
        } else if (leftType == Type.LONG && rightType == Type.LONG || leftType == Type.OBJECT && rightType == Type.LONG || leftType == Type.LONG && rightType == Type.OBJECT) {
            Boolean value = null;
            if (leftValue != null && rightValue != null) {
                value = (Long)leftValue >= (Long)rightValue ? Boolean.TRUE : Boolean.FALSE;
            }
            result = new ValueObject(value, Type.BOOLEAN);
        } else if (leftType == Type.DOUBLE && rightType == Type.DOUBLE || leftType == Type.OBJECT && rightType == Type.DOUBLE || leftType == Type.DOUBLE && rightType == Type.OBJECT) {
            Boolean value = null;
            if (leftValue != null && rightValue != null) {
                value = (Double)leftValue >= (Double)rightValue ? Boolean.TRUE : Boolean.FALSE;
            }
            result = new ValueObject(value, Type.BOOLEAN);
        } else if (leftType == Type.DOUBLE && rightType == Type.LONG) {
            Boolean value = (Double)leftValue >= (double)((Long)rightValue).longValue() ? Boolean.TRUE : Boolean.FALSE;
            result = new ValueObject(value, Type.BOOLEAN);
        } else if (leftType == Type.LONG && rightType == Type.DOUBLE) {
            Boolean value = (double)((Long)leftValue).longValue() >= (Double)rightValue ? Boolean.TRUE : Boolean.FALSE;
            result = new ValueObject(value, Type.BOOLEAN);
        }
        return result;
    }
}

