/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.extensions.customfunctions;

import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.extensions.customfunctions.CustomFunctionSourceProvider;

public class CustomFunctionsClassFactory {
    private static final String CLASS_NAME = "DynamicMethods";
    private static volatile Class<? extends Object> customFunctionsClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<? extends Object> getCustomFunctionsClass(CustomFunctionSourceProvider sourceProvider) {
        if (customFunctionsClass != null) return customFunctionsClass;
        Class<CustomFunctionsClassFactory> clazz = CustomFunctionsClassFactory.class;
        synchronized (CustomFunctionsClassFactory.class) {
            if (customFunctionsClass != null) return customFunctionsClass;
            customFunctionsClass = CustomFunctionsClassFactory.makeCustomFunctionsClass(sourceProvider);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return customFunctionsClass;
        }
    }

    private static Class<? extends Object> makeCustomFunctionsClass(CustomFunctionSourceProvider sourceProvider) {
        try {
            ClassPool pool = ClassPool.getDefault();
            ExpressionContext context = null;
            try {
                context = new ExpressionContext();
                pool.insertClassPath((ClassPath)new ClassClassPath(context.getClass()));
            }
            catch (ExpressionEngineException e) {
                throw new RuntimeException("Error creating ExpressionContext in CustomFunctionsClassFactory: " + e.getMessage(), e);
            }
            CtClass classDef = pool.makeClass(CLASS_NAME);
            String constructor = "public DynamicMethods(org.vedantatree.expressionoasis.ExpressionContext expressionContext) {}";
            CtConstructor constructorDef = CtNewConstructor.make((String)constructor, (CtClass)classDef);
            classDef.addConstructor(constructorDef);
            List<String> methodSources = sourceProvider.getFunctionSources();
            for (String methodSource : methodSources) {
                CtMethod methodDef = CtNewMethod.make((String)methodSource, (CtClass)classDef);
                classDef.addMethod(methodDef);
            }
            customFunctionsClass = classDef.toClass();
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Error creating custom functions class", e);
        }
        return customFunctionsClass;
    }
}

