/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.vedantatree.expressionoasis.config.ConstructorArgument;
import org.vedantatree.expressionoasis.extensions.FunctionProvider;

@Root(name="functionProvider")
public class FunctionProviderConfig {
    @Attribute(name="className")
    private final String className;
    @ElementList(name="constructorArgs", entry="constructorArg", required=false)
    private final List<ConstructorArgument> args;
    private FunctionProvider provider = null;

    public FunctionProviderConfig(@Attribute(name="className") String className, @ElementList(name="constructorArgs", entry="constructorArg", required=false) List<ConstructorArgument> args) {
        this.className = className;
        this.args = args;
    }

    public FunctionProvider getFunctionProvider() {
        if (this.provider == null) {
            try {
                Class<?> providerClass = Class.forName(this.className);
                Constructor<?> constructor = providerClass.getConstructor(this.getConstructorParameterTypes());
                this.provider = (FunctionProvider)constructor.newInstance(this.getConstructorParameterValues());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.provider;
    }

    private Class[] getConstructorParameterTypes() throws ClassNotFoundException {
        Class[] types;
        if (this.args != null) {
            types = new Class[this.args.size()];
            int i = 0;
            while (i < this.args.size()) {
                types[i] = Class.forName(this.args.get(i).getClassName());
                ++i;
            }
        } else {
            types = new Class[]{};
        }
        return types;
    }

    private Object[] getConstructorParameterValues() throws ClassNotFoundException {
        Object[] values;
        if (this.args != null) {
            values = new Class[this.args.size()];
            int i = 0;
            while (i < this.args.size()) {
                values[i] = this.args.get(i).getClassName().equals("java.lang.Class") ? Class.forName(this.args.get(i).getValue()) : this.args.get(i).getValue();
                ++i;
            }
        } else {
            values = new Class[]{};
        }
        return values;
    }
}

