/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions;

import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class DecimalExpression
implements Expression {
    private ValueObject decimalValue;

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        return this.decimalValue;
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        return Type.DOUBLE;
    }

    @Override
    public void initialize(ExpressionContext expressionContext, Object objectInfo, boolean validate) throws ExpressionEngineException {
        Double value = new Double((String)objectInfo);
        this.decimalValue = new ValueObject(value, Type.DOUBLE);
    }

    @Override
    public void uninitialize(ExpressionContext expressionContext) {
        this.decimalValue = null;
    }

    public String toString() {
        return this.decimalValue == null ? "null-not-initialized" : "" + this.decimalValue.getValue();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

