/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.arithmatic;

import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.UnaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class MinusExpression
extends UnaryOperatorExpression {
    static {
        MinusExpression.addTypePair(MinusExpression.class, Type.LONG, Type.LONG);
        MinusExpression.addTypePair(MinusExpression.class, Type.DOUBLE, Type.DOUBLE);
        MinusExpression.addTypePair(MinusExpression.class, Type.OBJECT, Type.OBJECT);
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Number value = (Number)this.getOperandExpression().getValue().getValue();
        Type resultType = this.getReturnType();
        if (value != null) {
            value = resultType == Type.LONG ? (Number)new Long(value.longValue() * -1L) : (Number)new Double(value.doubleValue() * -1.0);
        }
        return new ValueObject(value, resultType);
    }
}

