/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.arithmatic;

import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class RemainderExpression
extends BinaryOperatorExpression {
    static {
        RemainderExpression.addTypePair(RemainderExpression.class, Type.LONG, Type.LONG, Type.LONG);
        RemainderExpression.addTypePair(RemainderExpression.class, Type.LONG, Type.OBJECT, Type.LONG);
        RemainderExpression.addTypePair(RemainderExpression.class, Type.OBJECT, Type.LONG, Type.LONG);
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Object leftValue = this.leftOperandExpression.getValue().getValue();
        Object rightValue = this.rightOperandExpression.getValue().getValue();
        Long result = null;
        if (leftValue != null && rightValue != null) {
            result = new Long(((Number)leftValue).longValue() % ((Number)rightValue).longValue());
        }
        return new ValueObject(result, this.getReturnType());
    }
}

