/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.string;

import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class StartsWithExpression
extends BinaryOperatorExpression {
    static {
        StartsWithExpression.addTypePair(StartsWithExpression.class, Type.STRING, Type.STRING, Type.BOOLEAN);
        StartsWithExpression.addTypePair(StartsWithExpression.class, Type.OBJECT, Type.OBJECT, Type.BOOLEAN);
        StartsWithExpression.addTypePair(StartsWithExpression.class, Type.OBJECT, Type.STRING, Type.BOOLEAN);
        StartsWithExpression.addTypePair(StartsWithExpression.class, Type.STRING, Type.OBJECT, Type.BOOLEAN);
    }

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        Object leftValue = this.leftOperandExpression.getValue().getValue();
        Object rightValue = this.rightOperandExpression.getValue().getValue();
        Boolean result = false;
        Type returnType = this.getReturnType();
        if (leftValue != null && rightValue != null) {
            String leftStr = (String)leftValue;
            String rightStr = (String)rightValue;
            result = leftStr.toUpperCase().startsWith(rightStr.toUpperCase());
        }
        return new ValueObject(result, returnType);
    }
}

