/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter;

import de.fzi.power.binding.PowerBindingRepository;
import de.fzi.power.infrastructure.AbstractPowerConsumingResource;
import de.fzi.power.infrastructure.PowerConsumingEntity;
import de.fzi.power.infrastructure.PowerConsumingProvidingEntity;
import de.fzi.power.infrastructure.PowerProvidingEntity;
import de.fzi.power.infrastructure.StatefulPowerConsumingResourceSet;
import de.fzi.power.interpreter.AbstractEvaluationScope;
import de.fzi.power.interpreter.PowerModelRegistry;
import de.fzi.power.interpreter.PowerModelRegistryChangeListener;
import de.fzi.power.interpreter.calculators.AbstractDistributionPowerModelCalculator;
import de.fzi.power.interpreter.calculators.IResourcePowerModelCalculator;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.measure.quantity.Power;
import org.apache.commons.collections15.CollectionUtils;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;

public final class ConsumptionContext
implements PowerModelRegistryChangeListener {
    private final PowerBindingRepository bindingRepository;
    private final AbstractEvaluationScope scope;
    private final PowerModelRegistry powerModelRegistry;

    private ConsumptionContext(PowerBindingRepository bindingRepository, AbstractEvaluationScope initialScope, PowerModelRegistry powerModelRegistry) {
        if (bindingRepository == null || initialScope == null || powerModelRegistry == null) {
            throw new IllegalArgumentException("One of the given parameters was null!");
        }
        this.bindingRepository = bindingRepository;
        this.scope = initialScope;
        this.powerModelRegistry = powerModelRegistry;
        this.updateRequiredMetrics();
        powerModelRegistry.addObserver(this);
    }

    public static ConsumptionContext createConsumptionContext(PowerBindingRepository bindingRepository, AbstractEvaluationScope initialScope, PowerModelRegistry powerModelRegistry) {
        ConsumptionContext context = new ConsumptionContext(bindingRepository, initialScope, powerModelRegistry);
        return context;
    }

    public static ConsumptionContext createConsumptionContext(PowerProvidingEntity ppe, AbstractEvaluationScope initialScope, PowerModelRegistry powerModelRegistry) {
        if (ppe == null || ppe.getDistributionPowerAssemblyContext() == null) {
            throw new IllegalArgumentException("PowerProvidingEntity is null or not associated with a valid PowerBindingRepository instance.");
        }
        return new ConsumptionContext(ppe.getDistributionPowerAssemblyContext().getPowerBindingRepository(), initialScope, powerModelRegistry);
    }

    public Amount<Power> evaluateResourcePowerConsumption(AbstractPowerConsumingResource resource) {
        IResourcePowerModelCalculator calculator = this.powerModelRegistry.getCalculator(Objects.requireNonNull(resource, "Given resource must not be null."));
        if (calculator == null) {
            throw new IllegalArgumentException("Cannot evaluate power consumption of given resource: No corresponding calculator present in underlying power model registry!");
        }
        Collection<MeasuringValue> args = this.scope.getMeasurements((ProcessingResourceSpecification)resource.getProcessingResourceSpecifications().get(0));
        return calculator.calculate(args);
    }

    public Amount<Power> evaluateStatefulResourcePowerConsumption(StatefulPowerConsumingResourceSet resource) {
        return this.evaluateResourcePowerConsumption((AbstractPowerConsumingResource)resource);
    }

    public Amount<Power> evaluateDistributionPowerConsumption(PowerConsumingProvidingEntity powerConsumingProvidingEntity, Map<PowerConsumingEntity, Amount<Power>> consumers) {
        AbstractDistributionPowerModelCalculator distributionPowerCalculator = this.powerModelRegistry.getCalculator((PowerProvidingEntity)Objects.requireNonNull(powerConsumingProvidingEntity, "Given entity must not be null."));
        if (distributionPowerCalculator == null) {
            throw new IllegalArgumentException("Cannot evaluate power consumption of given distribution entity: No corresponding calculator present in underlying power model registry!");
        }
        Objects.requireNonNull(consumers, "Map of consumers must not be null");
        for (PowerConsumingEntity consumer : consumers.keySet()) {
            if (powerConsumingProvidingEntity.getId().equals(consumer.getPowerProvidingEntity().getId())) continue;
            throw new IllegalArgumentException("Power of " + consumer.getClass().getSimpleName() + "'" + consumer.getName() + "' is not supplied by the given providing entity '" + powerConsumingProvidingEntity.getName() + "'!");
        }
        return distributionPowerCalculator.calculate(consumers);
    }

    public PowerBindingRepository getPowerBindingRepository() {
        return this.bindingRepository;
    }

    public void cleanUp() {
        this.powerModelRegistry.removeObserver(this);
    }

    private void updateRequiredMetrics() {
        Map<AbstractPowerConsumingResource, Set<MetricDescription>> requiredMetricsPerResource = this.powerModelRegistry.getRequiredMetricsForRegisteredCalculators();
        this.scope.setResourceMetricsToEvaluate(requiredMetricsPerResource.entrySet().stream().collect(Collectors.toMap(entry -> (ProcessingResourceSpecification)((AbstractPowerConsumingResource)entry.getKey()).getProcessingResourceSpecifications().get(0), entry -> (Set)entry.getValue())));
    }

    @Override
    public void resourcePowerModelChanged(IResourcePowerModelCalculator calculator, AbstractPowerConsumingResource affectedResource) {
        Map<AbstractPowerConsumingResource, Set<MetricDescription>> requiredMetricsPerResource = this.powerModelRegistry.getRequiredMetricsForRegisteredCalculators();
        if (!CollectionUtils.isSubCollection(calculator.getInputMetrics(), (Iterable)requiredMetricsPerResource.get(affectedResource))) {
            throw new IllegalArgumentException("it is currently not possibly to change the power model calculator of a resource, if the new calculator requires different metrics to be evaluated!");
        }
    }

    @Override
    public void distributionPowerModelChanged(AbstractDistributionPowerModelCalculator calculator, PowerProvidingEntity affectedEntity) {
    }
}

