/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.vedantatree.expressionoasis.config.ConfigFactory;
import org.vedantatree.expressionoasis.config.ExpressionConfig;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.property.FunctionExpression;

public class ExpressionFactory {
    private static ExpressionFactory SHARED_INSTANCE = new ExpressionFactory();
    public static final String UNARY = "unary";
    public static final String BINARY = "binary";
    public static final String FUNCTION = "function";
    public static final String OPERAND = "operand";
    public static final String TRUE = "true";
    private Map<String, Map<String, Class>> expressionTypeClassMapping = new HashMap<String, Map<String, Class>>();
    private Map<String, Pattern> operandRegExCache = new HashMap<String, Pattern>();

    private ExpressionFactory() {
        this.configure();
    }

    public static ExpressionFactory getInstance() {
        return SHARED_INSTANCE;
    }

    public void addFunction(String functionName) {
    }

    private void configure() {
        this.expressionTypeClassMapping.put(UNARY, new HashMap());
        this.expressionTypeClassMapping.put(BINARY, new HashMap());
        this.expressionTypeClassMapping.put(OPERAND, new HashMap());
        List<ExpressionConfig> expressions = ConfigFactory.getConfig().getExpressionConfigs();
        for (ExpressionConfig expression : expressions) {
            String expressionType = expression.getExpressionType();
            String expressionToken = expression.getExpressionName();
            Class expressionClass = expression.getExpressionClass();
            Map<String, Class> expressionClassMap = this.expressionTypeClassMapping.get(expressionType);
            expressionClassMap.put(expressionToken, expressionClass);
            if (!expressionType.equals(OPERAND)) continue;
            Pattern pattern = Pattern.compile(expressionToken);
            this.operandRegExCache.put(expressionToken, pattern);
        }
    }

    public Expression createExpression(String expressionToken, String type) throws ExpressionEngineException {
        Class expressionClass = null;
        Map<String, Class> expressionTokenClassMap = this.expressionTypeClassMapping.get(type);
        if (FUNCTION.equals(type)) {
            expressionClass = FunctionExpression.class;
        } else if (OPERAND.equals(type)) {
            for (Map.Entry<String, Pattern> operandTokenRegEx : this.operandRegExCache.entrySet()) {
                Matcher operandMatcher = operandTokenRegEx.getValue().matcher(expressionToken);
                if (!operandMatcher.matches()) continue;
                expressionClass = expressionTokenClassMap.get(operandTokenRegEx.getKey());
                break;
            }
            Assert.assertNotNull((String)("If expression token is of Operand type, corresponding regular expression must be defined in config.xml. No regular expression, hence no expression class found for [" + expressionToken + "]"), expressionClass);
        } else {
            Class clazz = expressionClass = expressionTokenClassMap == null ? null : expressionTokenClassMap.get(expressionToken);
        }
        if (expressionClass == null) {
            throw new ExpressionEngineException("Unable to find any expression class mapping for token \"" + expressionToken + "\" in type \"" + type + "\"");
        }
        try {
            return (Expression)expressionClass.newInstance();
        }
        catch (Exception ex) {
            throw new ExpressionEngineException("Unable to create the expression for token[" + expressionToken + "] in type[" + type + "]");
        }
    }
}

