/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.expressions.property;

import java.util.ArrayList;
import java.util.List;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.UnaryOperatorExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.ParanthesisExpression;
import org.vedantatree.expressionoasis.expressions.property.ArgumentExpression;
import org.vedantatree.expressionoasis.extensions.FunctionProvider;
import org.vedantatree.expressionoasis.types.MethodKey;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public class FunctionExpression
extends UnaryOperatorExpression {
    private String functionName;
    private FunctionProvider functionProvider;

    @Override
    public ValueObject getValue() throws ExpressionEngineException {
        ArrayList values = new ArrayList();
        ParanthesisExpression argsExpression = (ParanthesisExpression)this.getOperandExpression();
        this.populateTypesAndValues(argsExpression.getOperandExpression(), null, values);
        ValueObject[] parameters = values.toArray(new ValueObject[values.size()]);
        return this.functionProvider.getFunctionValue(this.functionName, parameters);
    }

    @Override
    public Type getReturnType() throws ExpressionEngineException {
        ArrayList types = new ArrayList();
        ParanthesisExpression argsExpression = (ParanthesisExpression)this.getOperandExpression();
        this.populateTypesAndValues(argsExpression.getOperandExpression(), types, null);
        Type[] parameterTypes = types.toArray(new Type[types.size()]);
        return this.functionProvider.getFunctionType(this.functionName, parameterTypes);
    }

    @Override
    public void initialize(ExpressionContext expressionContext, Object parameters, boolean validate) throws ExpressionEngineException {
        this.functionName = (String)expressionContext.getContextProperty("TOKEN");
        super.initialize(expressionContext, parameters, validate);
    }

    @Override
    protected void validate(ExpressionContext expressionContext) throws ExpressionEngineException {
        ParanthesisExpression argsExpression = (ParanthesisExpression)this.getOperandExpression();
        ArrayList types = new ArrayList();
        ArrayList values = new ArrayList();
        this.populateTypesAndValues(argsExpression.getOperandExpression(), types, values);
        Type[] parameterTypes = types.toArray(new Type[types.size()]);
        for (FunctionProvider functionProvider : expressionContext.getFunctionProviders()) {
            if (!functionProvider.supportsFunction(this.functionName, parameterTypes)) continue;
            this.functionProvider = functionProvider;
            break;
        }
        if (this.functionProvider == null) {
            throw new ExpressionEngineException("No Function Provider exists for function: [" + MethodKey.generateKey(this.functionName, parameterTypes) + "]");
        }
    }

    private void populateTypesAndValues(Expression expression, List types, List values) throws ExpressionEngineException {
        if (expression instanceof ArgumentExpression) {
            ArgumentExpression argExp = (ArgumentExpression)expression;
            this.populateTypesAndValues(argExp.getLeftOperandExpression(), types, values);
            this.populateTypesAndValues(argExp.getRightOperandExpression(), types, values);
        } else if (expression != null) {
            if (types != null) {
                types.add(expression.getReturnType());
            }
            if (values != null) {
                values.add(expression.getValue());
            }
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

