/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.extensions;

import java.util.HashMap;
import java.util.Map;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.extensions.VariableProvider;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;
import org.vedantatree.expressionoasis.utils.StringUtils;

public class DefaultVariableProvider
implements VariableProvider {
    private Map<String, ValueObject> variableValues = new HashMap<String, ValueObject>();

    @Override
    public void initialize(ExpressionContext expressionContext) throws ExpressionEngineException {
    }

    public void addVariable(String variableName, ValueObject valueObject) {
        if (!StringUtils.isQualifiedString(variableName) || valueObject == null) {
            throw new IllegalArgumentException("Passed parameters are not valid.");
        }
        this.variableValues.put(variableName, valueObject);
    }

    public void removeVariable(String variableName) {
        this.variableValues.remove(variableName);
    }

    public void clear() {
        this.variableValues.clear();
    }

    @Override
    public Type getVariableType(String variableName) throws ExpressionEngineException {
        Type varType = null;
        if (this.supportsVariable(variableName)) {
            varType = this.variableValues.get(variableName).getValueType();
        }
        return varType;
    }

    @Override
    public ValueObject getVariableValue(String variableName) throws ExpressionEngineException {
        ValueObject varValue = null;
        varValue = this.variableValues.get(variableName);
        return varValue;
    }

    @Override
    public boolean supportsVariable(String variableName) throws ExpressionEngineException {
        return this.variableValues.containsKey(variableName);
    }
}

