/*
 * Decompiled with CFR 0.152.
 */
package org.vedantatree.expressionoasis.utils;

import java.util.HashMap;
import java.util.Map;

public final class JavaUtils {
    private static Map<Class, Class> primitiveToWrappers = new HashMap<Class, Class>();
    private static Map<Class, Class> wrapperToprimitives = new HashMap<Class, Class>();

    static {
        primitiveToWrappers.put(Integer.TYPE, Integer.class);
        primitiveToWrappers.put(Long.TYPE, Long.class);
        primitiveToWrappers.put(Short.TYPE, Short.class);
        primitiveToWrappers.put(Byte.TYPE, Byte.class);
        primitiveToWrappers.put(Double.TYPE, Double.class);
        primitiveToWrappers.put(Float.TYPE, Float.class);
        primitiveToWrappers.put(Boolean.TYPE, Boolean.class);
        primitiveToWrappers.put(Character.TYPE, Character.class);
        primitiveToWrappers.put(Void.TYPE, Void.class);
        wrapperToprimitives.put(Integer.class, Integer.TYPE);
        wrapperToprimitives.put(Long.class, Long.TYPE);
        wrapperToprimitives.put(Short.class, Short.TYPE);
        wrapperToprimitives.put(Byte.class, Byte.TYPE);
        wrapperToprimitives.put(Double.class, Double.TYPE);
        wrapperToprimitives.put(Float.class, Float.TYPE);
        wrapperToprimitives.put(Boolean.class, Boolean.TYPE);
        wrapperToprimitives.put(Character.class, Character.TYPE);
        wrapperToprimitives.put(Void.class, Void.TYPE);
    }

    private JavaUtils() {
    }

    public static final Class convertToWrapper(Class type) {
        if (type == null || !type.isPrimitive()) {
            throw new IllegalArgumentException("Given class type is wrong. Either it is null or not a primitive. given-class[" + type + "]");
        }
        return primitiveToWrappers.get(type);
    }

    public static final Class convertToPrimitive(Class type) {
        if (type == null || type.isPrimitive()) {
            throw new IllegalArgumentException("Given class type is wrong. Either it is null or is a primitive. given-class[" + type + "]");
        }
        return wrapperToprimitives.get(type);
    }
}

