/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators.essential;

import de.fzi.power.binding.DistributionPowerBinding;
import de.fzi.power.binding.ResourcePowerBinding;
import de.fzi.power.interpreter.calculators.AbstractCalculatorFactory;
import de.fzi.power.interpreter.calculators.AbstractDistributionPowerModelCalculator;
import de.fzi.power.interpreter.calculators.AbstractResourcePowerModelCalculator;
import de.fzi.power.interpreter.calculators.IResourcePowerModelCalculator;
import de.fzi.power.interpreter.calculators.essential.InterpolationModelCalculator;
import de.fzi.power.interpreter.calculators.essential.LinearPassthroughCalculator;
import de.fzi.power.interpreter.calculators.essential.LinearPowerModelCalculator;
import de.fzi.power.interpreter.calculators.essential.NonlinearRegressionCalculator;
import de.fzi.power.specification.resources.PowerModelConstants;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EssentialCalculatorsFactory
extends AbstractCalculatorFactory {
    private static final int ESSENTIAL_POWER_MODEL_CALCULATORS_PRIORITY = 50;
    private static final Set<String> SUPPORTED_DISTRIBUTION_MODELS = new HashSet<String>(Arrays.asList(PowerModelConstants.LINEAR_PASSTHROUGH_DISTRIBUTION.getId()));
    private static final Set<String> SUPPORTED_RESOURCE_MODELS = new HashSet<String>(Arrays.asList(PowerModelConstants.LINEAR_POWER_MODEL.getId(), PowerModelConstants.NONLINEAR_REGRESSION_MODEL.getId(), PowerModelConstants.INTERPOLATION_MODEL.getId()));

    public IResourcePowerModelCalculator instantiateResourcePowerModelCalculator(ResourcePowerBinding binding) {
        AbstractResourcePowerModelCalculator calculator = null;
        if (binding.getResourcePowerModelSpecification().getId().equals(PowerModelConstants.LINEAR_POWER_MODEL.getId())) {
            calculator = new LinearPowerModelCalculator(binding);
        } else if (binding.getResourcePowerModelSpecification().getId().equals(PowerModelConstants.NONLINEAR_REGRESSION_MODEL.getId())) {
            calculator = new NonlinearRegressionCalculator(binding);
        } else if (binding.getResourcePowerModelSpecification().getId().equals(PowerModelConstants.INTERPOLATION_MODEL.getId())) {
            calculator = new InterpolationModelCalculator(binding);
        }
        return calculator != null ? calculator : super.instantiateResourcePowerModelCalculator(binding);
    }

    public AbstractDistributionPowerModelCalculator instantiateDistributionPowerModelCalculator(DistributionPowerBinding binding) {
        LinearPassthroughCalculator calculator = null;
        if (binding.getDistributionPowerModel().getId().equals(PowerModelConstants.LINEAR_PASSTHROUGH_DISTRIBUTION.getId())) {
            calculator = new LinearPassthroughCalculator(binding);
        }
        return calculator != null ? calculator : super.instantiateDistributionPowerModelCalculator(binding);
    }

    public int getPriority() {
        return 50;
    }

    protected Set<String> getSupportedDistributionPowerModelIds() {
        return Collections.unmodifiableSet(SUPPORTED_DISTRIBUTION_MODELS);
    }

    protected Set<String> getSupportedResourcePowerModelIds() {
        return Collections.unmodifiableSet(SUPPORTED_RESOURCE_MODELS);
    }
}

