/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators.essential;

import de.fzi.power.binding.ResourcePowerBinding;
import de.fzi.power.interpreter.calculators.AbstractResourcePowerModelCalculator;
import de.fzi.power.specification.resources.PowerModelConstants;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Power;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class InterpolationModelCalculator
extends AbstractResourcePowerModelCalculator {
    private static final MetricDescription utilMetric = MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE;

    public InterpolationModelCalculator(ResourcePowerBinding binding) {
        super(binding);
        if (!binding.getResourcePowerModelSpecification().getId().equals(PowerModelConstants.INTERPOLATION_MODEL.getId())) {
            throw new IllegalArgumentException("Referred model wasn't the linear power model from" + PowerModelConstants.LINEAR_POWER_MODEL.eResource().getURI() + ".");
        }
    }

    public Amount<Power> calculate(Collection<MeasuringValue> measurements) {
        Measure utilization = measurements.iterator().next().getMeasureForMetric(utilMetric);
        Amount utilAmount = Amount.valueOf((double)((Double)utilization.getValue()), (Unit)utilization.getUnit());
        utilAmount = utilAmount.times(16L);
        Amount power = null;
        power = utilAmount.getEstimatedValue() < 1.0 ? Amount.valueOf((double)utilAmount.pow(6).times(8212.668823123).minus(utilAmount.pow(5).times(23972.189733744)).plus(utilAmount.pow(4).times(25344.996817589)).minus(utilAmount.pow(3).times(11469.130619764)).plus(utilAmount.pow(2).times(1934.889201581)).plus(utilAmount.times(39.956358727)).plus(Amount.valueOf((double)270.543705037, (Unit)Dimensionless.UNIT)).getEstimatedValue(), (Unit)SI.WATT) : Amount.valueOf((double)utilAmount.times(7.19455).plus(Amount.valueOf((double)352.46688, (Unit)Dimensionless.UNIT)).getEstimatedValue(), (Unit)SI.WATT);
        return power;
    }

    public Set<MetricDescription> getInputMetrics() {
        return Collections.singleton(utilMetric);
    }
}

