/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators;

import de.fzi.power.binding.TransitionStateBinding;
import de.fzi.power.infrastructure.InfrastructurePackage;
import de.fzi.power.infrastructure.StatefulPowerConsumingResourceSet;
import de.fzi.power.interpreter.calculators.IResourcePowerModelCalculator;
import de.fzi.power.interpreter.calculators.ITimeProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Power;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import tools.descartes.dlim.generator.ModelEvaluator;

public class TransitionStatePowerModelCalculator
implements IResourcePowerModelCalculator {
    private final ModelEvaluator evaluator;
    private final Unit<Power> targetUnit;
    Amount<Duration> transitionStart;

    public TransitionStatePowerModelCalculator(StatefulPowerConsumingResourceSet resource, TransitionStateBinding stateBinding, final ITimeProvider provider) {
        resource.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                if (notification.getEventType() == 1 && InfrastructurePackage.eINSTANCE.getStatefulPowerConsumingResourceSet().isInstance(notification.getNotifier()) && InfrastructurePackage.eINSTANCE.getStatefulPowerConsumingResourceSet_PowerState().equals(notification.getFeature())) {
                    TransitionStatePowerModelCalculator.this.transitionStart = provider.getCurrentTime();
                }
            }
        });
        this.evaluator = new ModelEvaluator(stateBinding.getTransitionConsumption().getPowerCurve());
        this.targetUnit = stateBinding.getTransitionConsumption().getUnit();
    }

    @Override
    public Amount<Power> calculate(Collection<MeasuringValue> list) {
        NumericalBaseMetricDescription timeMetric = MetricDescriptionConstants.POINT_IN_TIME_METRIC;
        Measure curTime = list.stream().map(m -> m.getMeasureForMetric((MetricDescription)timeMetric)).findAny().get();
        double timeDiff = curTime.doubleValue(this.transitionStart.getUnit()) - this.transitionStart.doubleValue(this.transitionStart.getUnit());
        double consumption = this.evaluator.getArrivalRateAtTime(timeDiff);
        return Amount.valueOf((double)consumption, this.targetUnit);
    }

    @Override
    public Set<MetricDescription> getInputMetrics() {
        return Collections.singleton(MetricDescriptionConstants.POINT_IN_TIME_METRIC);
    }
}

