/**
 */
package org.palladiosimulator.servicelevelobjective.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.servicelevelobjective.util.ServicelevelObjectiveAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * @generated
 */
public class ServicelevelObjectiveItemProviderAdapterFactory extends ServicelevelObjectiveAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ServicelevelObjectiveItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceLevelObjectiveRepositoryItemProvider serviceLevelObjectiveRepositoryItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createServiceLevelObjectiveRepositoryAdapter() {
		if (serviceLevelObjectiveRepositoryItemProvider == null) {
			serviceLevelObjectiveRepositoryItemProvider = new ServiceLevelObjectiveRepositoryItemProvider(this);
		}

		return serviceLevelObjectiveRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.palladiosimulator.servicelevelobjective.ServiceLevelObjective} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected ServiceLevelObjectiveItemProvider serviceLevelObjectiveItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.palladiosimulator.servicelevelobjective.ServiceLevelObjective}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createServiceLevelObjectiveAdapter() {
		if (serviceLevelObjectiveItemProvider == null) {
			serviceLevelObjectiveItemProvider = new ServiceLevelObjectiveItemProvider(this);
		}

		return serviceLevelObjectiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.palladiosimulator.servicelevelobjective.HardThreshold} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected HardThresholdItemProvider hardThresholdItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.servicelevelobjective.HardThreshold}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHardThresholdAdapter() {
		if (hardThresholdItemProvider == null) {
			hardThresholdItemProvider = new HardThresholdItemProvider(this);
		}

		return hardThresholdItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.palladiosimulator.servicelevelobjective.LinearFuzzyThreshold} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected LinearFuzzyThresholdItemProvider linearFuzzyThresholdItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.servicelevelobjective.LinearFuzzyThreshold}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLinearFuzzyThresholdAdapter() {
		if (linearFuzzyThresholdItemProvider == null) {
			linearFuzzyThresholdItemProvider = new LinearFuzzyThresholdItemProvider(this);
		}

		return linearFuzzyThresholdItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.palladiosimulator.servicelevelobjective.NamedElement} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected NamedElementItemProvider namedElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.servicelevelobjective.NamedElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNamedElementAdapter() {
		if (namedElementItemProvider == null) {
			namedElementItemProvider = new NamedElementItemProvider(this);
		}

		return namedElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.servicelevelobjective.SoftThreshold} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SoftThresholdItemProvider softThresholdItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.servicelevelobjective.SoftThreshold}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSoftThresholdAdapter() {
		if (softThresholdItemProvider == null) {
			softThresholdItemProvider = new SoftThresholdItemProvider(this);
		}

		return softThresholdItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.servicelevelobjective.QuadraticFuzzyThreshold} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QuadraticFuzzyThresholdItemProvider quadraticFuzzyThresholdItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.servicelevelobjective.QuadraticFuzzyThreshold}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQuadraticFuzzyThresholdAdapter() {
		if (quadraticFuzzyThresholdItemProvider == null) {
			quadraticFuzzyThresholdItemProvider = new QuadraticFuzzyThresholdItemProvider(this);
		}

		return quadraticFuzzyThresholdItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.servicelevelobjective.NegativeQuadraticFuzzyThreshold} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NegativeQuadraticFuzzyThresholdItemProvider negativeQuadraticFuzzyThresholdItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.servicelevelobjective.NegativeQuadraticFuzzyThreshold}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNegativeQuadraticFuzzyThresholdAdapter() {
		if (negativeQuadraticFuzzyThresholdItemProvider == null) {
			negativeQuadraticFuzzyThresholdItemProvider = new NegativeQuadraticFuzzyThresholdItemProvider(this);
		}

		return negativeQuadraticFuzzyThresholdItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (serviceLevelObjectiveRepositoryItemProvider != null)
			serviceLevelObjectiveRepositoryItemProvider.dispose();
		if (serviceLevelObjectiveItemProvider != null)
			serviceLevelObjectiveItemProvider.dispose();
		if (hardThresholdItemProvider != null)
			hardThresholdItemProvider.dispose();
		if (linearFuzzyThresholdItemProvider != null)
			linearFuzzyThresholdItemProvider.dispose();
		if (namedElementItemProvider != null)
			namedElementItemProvider.dispose();
		if (softThresholdItemProvider != null)
			softThresholdItemProvider.dispose();
		if (quadraticFuzzyThresholdItemProvider != null)
			quadraticFuzzyThresholdItemProvider.dispose();
		if (negativeQuadraticFuzzyThresholdItemProvider != null)
			negativeQuadraticFuzzyThresholdItemProvider.dispose();
	}

}
