/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.util;

import java.util.ArrayList;
import java.util.List;
import javax.measure.Measure;
import javax.measure.unit.Unit;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.edp2.visualization.util.DataAggregationModeTypes;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class SLODataAggregationMode {
    private double timestep = 10.0;
    private final DataAggregationModeTypes type;

    public SLODataAggregationMode(DataAggregationModeTypes type) {
        this.type = type;
    }

    public double[][] computeAggregateddata(List<Measurement> measurements) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        ArrayList<Double> inputList = new ArrayList<Double>();
        ArrayList<double[][]> xyDataList = new ArrayList<double[][]>();
        for (Measurement currentMeasurement : measurements) {
            xyDataList.add(this.getXYData(this.returnDataTupleFromMeasurement(currentMeasurement)));
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int l = 0;
        while (l < xyDataList.size()) {
            indexList.add(new Integer(0));
            ++l;
        }
        for (double[][] currentXY : xyDataList) {
            inputList.add(currentXY[0][currentXY[0].length - 1]);
        }
        for (Double currentDouble : inputList) {
            stats.addValue(currentDouble.doubleValue());
        }
        int maxSimulationTime = (int)stats.getMax();
        stats.clear();
        inputList.clear();
        double[][] outputData = new double[2][(int)Math.ceil((double)maxSimulationTime / this.timestep)];
        switch (this.type) {
            case MAX: {
                double time = this.timestep;
                int numberOfSteps = 0;
                for (Integer currentInt : indexList) {
                    indexList.set(indexList.indexOf(currentInt), new Integer(0));
                }
                while (time <= (double)maxSimulationTime) {
                    for (double[][] currentXY : xyDataList) {
                        int i = 0;
                        while (currentXY[0][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i] <= time) {
                            if (currentXY[0][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i] > time - this.timestep) {
                                inputList.add(currentXY[1][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i]);
                            }
                            ++i;
                        }
                        Integer newIndex = (Integer)indexList.get(xyDataList.indexOf(currentXY));
                        newIndex = newIndex + i;
                        indexList.set(xyDataList.indexOf(currentXY), newIndex);
                    }
                    for (Double currentDouble : inputList) {
                        stats.addValue(currentDouble.doubleValue());
                    }
                    inputList.clear();
                    outputData[0][numberOfSteps] = time;
                    outputData[1][numberOfSteps] = stats.getMax();
                    ++numberOfSteps;
                    stats.clear();
                    if (time + this.timestep > (double)maxSimulationTime && time != (double)maxSimulationTime) {
                        time = maxSimulationTime;
                        continue;
                    }
                    time += this.timestep;
                }
                numberOfSteps = 0;
                time = this.timestep;
                break;
            }
            case MIN: {
                double time = this.timestep;
                int numberOfSteps = 0;
                for (Integer currentInt : indexList) {
                    indexList.set(indexList.indexOf(currentInt), new Integer(0));
                }
                while (time <= (double)maxSimulationTime) {
                    for (double[][] currentXY : xyDataList) {
                        int i = 0;
                        while (currentXY[0][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i] <= time) {
                            if (currentXY[0][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i] > time - this.timestep) {
                                inputList.add(currentXY[1][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i]);
                            }
                            ++i;
                        }
                        Integer newIndex = (Integer)indexList.get(xyDataList.indexOf(currentXY));
                        newIndex = newIndex + i;
                        indexList.set(xyDataList.indexOf(currentXY), newIndex);
                    }
                    for (Double currentDouble : inputList) {
                        stats.addValue(currentDouble.doubleValue());
                    }
                    inputList.clear();
                    outputData[0][numberOfSteps] = time;
                    outputData[1][numberOfSteps] = stats.getMin();
                    ++numberOfSteps;
                    stats.clear();
                    if (time + this.timestep > (double)maxSimulationTime && time != (double)maxSimulationTime) {
                        time = maxSimulationTime;
                        continue;
                    }
                    time += this.timestep;
                }
                numberOfSteps = 0;
                time = this.timestep;
                break;
            }
            case MEAN: {
                double time = this.timestep;
                int numberOfSteps = 0;
                for (Integer currentInt : indexList) {
                    indexList.set(indexList.indexOf(currentInt), new Integer(0));
                }
                while (time <= (double)maxSimulationTime) {
                    for (double[][] currentXY : xyDataList) {
                        int i = 0;
                        while ((Integer)indexList.get(xyDataList.indexOf(currentXY)) + i < currentXY[0].length && currentXY[0][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i] <= time) {
                            if (currentXY[0][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i] > time - this.timestep) {
                                inputList.add(currentXY[1][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i]);
                            }
                            ++i;
                        }
                        Integer newIndex = (Integer)indexList.get(xyDataList.indexOf(currentXY));
                        newIndex = newIndex + i;
                        indexList.set(xyDataList.indexOf(currentXY), newIndex);
                    }
                    for (Double currentDouble : inputList) {
                        stats.addValue(currentDouble.doubleValue());
                    }
                    inputList.clear();
                    outputData[0][numberOfSteps] = time;
                    outputData[1][numberOfSteps] = stats.getMean();
                    ++numberOfSteps;
                    stats.clear();
                    if (time + this.timestep > (double)maxSimulationTime && time != (double)maxSimulationTime) {
                        time = maxSimulationTime;
                        continue;
                    }
                    time += this.timestep;
                }
                numberOfSteps = 0;
                time = this.timestep;
                break;
            }
            case MEDIAN: {
                double time = this.timestep;
                int numberOfSteps = 0;
                for (Integer currentInt : indexList) {
                    indexList.set(indexList.indexOf(currentInt), new Integer(0));
                }
                while (time <= (double)maxSimulationTime) {
                    for (double[][] currentXY : xyDataList) {
                        int i = 0;
                        while (currentXY[0][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i] <= time) {
                            if (currentXY[0][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i] > time - this.timestep) {
                                inputList.add(currentXY[1][(Integer)indexList.get(xyDataList.indexOf(currentXY)) + i]);
                            }
                            ++i;
                        }
                        Integer newIndex = (Integer)indexList.get(xyDataList.indexOf(currentXY));
                        newIndex = newIndex + i;
                        indexList.set(xyDataList.indexOf(currentXY), newIndex);
                    }
                    for (Double currentDouble : inputList) {
                        stats.addValue(currentDouble.doubleValue());
                    }
                    inputList.clear();
                    outputData[0][numberOfSteps] = time;
                    outputData[1][numberOfSteps] = stats.getPercentile(50.0);
                    ++numberOfSteps;
                    stats.clear();
                    if (time + this.timestep > (double)maxSimulationTime && time != (double)maxSimulationTime) {
                        time = maxSimulationTime;
                        continue;
                    }
                    time += this.timestep;
                }
                numberOfSteps = 0;
                double d = this.timestep;
            }
        }
        return outputData;
    }

    private double[][] getXYData(IDataSource dataSource) {
        if (!this.canAccept(dataSource)) {
            throw new IllegalArgumentException("XYData has to be a two-dimensional metric set description.");
        }
        IDataStream inputStream = dataSource.getDataStream();
        EList subsumedMetrics = ((MetricSetDescription)inputStream.getMetricDesciption()).getSubsumedMetrics();
        int xPos = 0;
        if (((MetricDescription)subsumedMetrics.get(1)).getId().equals(MetricDescriptionConstants.POINT_IN_TIME_METRIC.getId())) {
            xPos = 1;
        }
        int yPos = 1 - xPos;
        Unit domainUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(xPos)).getDefaultUnit();
        Unit rangeUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(yPos)).getDefaultUnit();
        try {
            double[][] result = new double[2][inputStream.size()];
            int i = 0;
            for (TupleMeasurement tuple : inputStream) {
                Measure[] measurement = tuple.asArray();
                result[0][i] = measurement[xPos].doubleValue(domainUnit);
                result[1][i] = measurement[yPos].doubleValue(rangeUnit);
                ++i;
            }
            double[][] dArray = result;
            return dArray;
        }
        finally {
            inputStream.close();
        }
    }

    private IDataSource returnDataTupleFromMeasurement(Measurement source) {
        Measurement measurements = source;
        RawMeasurements rawMeasurements = ((MeasurementRange)measurements.getMeasurementRanges().get(0)).getRawMeasurements();
        if (rawMeasurements != null && !rawMeasurements.getDataSeries().isEmpty()) {
            Edp2DataTupleDataSource edp2Source = new Edp2DataTupleDataSource(rawMeasurements);
            int dataStreamSize = edp2Source.getDataStream().size();
            edp2Source.getDataStream().close();
            if (dataStreamSize > 0) {
                return edp2Source;
            }
        } else {
            throw new RuntimeException("Empty Measurements!");
        }
        return null;
    }

    public boolean canAccept(IDataSource source) {
        BaseMetricDescription[] mds = MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)source.getMetricDesciption());
        if (mds.length != 2) {
            return false;
        }
        BaseMetricDescription[] baseMetricDescriptionArray = mds;
        int n = mds.length;
        int n2 = 0;
        while (n2 < n) {
            BaseMetricDescription md = baseMetricDescriptionArray[n2];
            if (!(md instanceof NumericalBaseMetricDescription)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getDescription() {
        return this.type.name();
    }

    public void setTimestep(double timestep) {
        this.timestep = timestep;
    }
}

