/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.measuringpoint.impl.StringMeasuringPointImpl;
import org.palladiosimulator.edp2.visualization.util.DataAggregationModeTypes;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.util.SLODataAggregationMode;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLOViewsWizard;

public class SLODialogAggDataPage
extends WizardPage
implements ISelectionChangedListener,
SelectionListener {
    private double timestep = 10.0;
    private Scale scale;
    private String measuringPointsLabel;
    private List<Measurement> measurementsList;
    private final List<SLODataAggregationMode> dataAggregationModes;
    private TableViewer choiceViewer;
    private SLODataAggregationMode selectedMode;
    private IStatus selectionStatus;
    private final Status statusOK;

    protected SLODialogAggDataPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.dataAggregationModes = new ArrayList<SLODataAggregationMode>();
        DataAggregationModeTypes[] dataAggregationModeTypesArray = DataAggregationModeTypes.values();
        int n = dataAggregationModeTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataAggregationModeTypes modus = dataAggregationModeTypesArray[n2];
            SLODataAggregationMode aggModus = new SLODataAggregationMode(modus);
            this.dataAggregationModes.add(aggModus);
            ++n2;
        }
        this.setDescription("Please select one aggregation mode to proceed.");
        this.setErrorMessage("Aggregation modus not applicable.");
        this.selectionStatus = new Status(1, "not_used", 0, "Please select one aggregation mode to proceed.", null);
        this.statusOK = new Status(0, "not_used", 0, "", null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        label.setText("Available Choices:");
        SashForm sashForm = new SashForm(composite, 256);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        sashForm.setLayoutData((Object)gd);
        this.choiceViewer = new TableViewer((Composite)sashForm, 2048);
        this.initializeChoiceViewer();
        Label scaleLabel = new Label(composite, 0);
        scaleLabel.setText("Specify the time intervall for data aggregation [s]:");
        this.scale = new Scale(composite, 0);
        this.scale.setSelection(10);
        this.scale.setMinimum(1);
        this.scale.setToolTipText("" + this.scale.getSelection());
        this.scale.addSelectionListener((SelectionListener)this);
        this.setControl((Control)composite);
        this.updatePageStatus();
    }

    private void initializeChoiceViewer() {
        this.choiceViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return SLODialogAggDataPage.this.dataAggregationModes.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.choiceViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element != null) {
                    SLODataAggregationMode sequenceElement = (SLODataAggregationMode)element;
                    StringBuffer result = new StringBuffer();
                    result.append("Aggregation mode: " + sequenceElement.getDescription());
                    return result.toString();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.choiceViewer.setInput(this.dataAggregationModes);
        this.choiceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionStatus = this.statusOK;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.selectionStatus = new Status(4, "not_used", 0, "Please select an aggregation mode to proceed.", null);
        } else {
            List list = selection.toList();
            this.selectedMode = (SLODataAggregationMode)list.get(0);
            this.selectedMode.setTimestep(this.timestep);
            double[][] aggregatedData = this.computeAggregatedData();
            this.setAggregatedDataInWizard(aggregatedData);
            ((SLOViewsWizard)this.getWizard()).setMeasuringPointLabel(this.measuringPointsLabel);
            this.selectionStatus = this.statusOK;
        }
        this.updatePageStatus();
    }

    private double[][] computeAggregatedData() {
        return this.selectedMode.computeAggregateddata(this.measurementsList);
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = super.getNextPage();
        if (this.selectedMode != null) {
            this.selectedMode.setTimestep(this.timestep);
            double[][] aggregatedData = this.computeAggregatedData();
            this.setAggregatedDataInWizard(aggregatedData);
            ((SLOViewsWizard)this.getWizard()).setMeasuringPointLabel(String.valueOf(this.measuringPointsLabel) + " Aggregation time interval: " + this.timestep + " s. Aggregation mode: " + this.selectedMode.getDescription());
        }
        return nextPage;
    }

    public IStatus updatePageStatus() {
        Status pageStatus = this.statusOK;
        ((SLOViewsWizard)this.getWizard()).setFinishable(false);
        switch (this.selectionStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage());
                pageStatus = this.statusOK;
                this.setPageComplete(true);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 2);
                pageStatus = this.selectionStatus;
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 1);
                pageStatus = this.selectionStatus;
                break;
            }
            default: {
                this.setErrorMessage(this.selectionStatus.getMessage());
                this.setMessage(null);
                pageStatus = this.selectionStatus;
            }
        }
        return pageStatus;
    }

    public void widgetSelected(SelectionEvent e) {
        this.timestep = this.scale.getSelection();
        this.scale.setToolTipText("" + this.scale.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void setAggregatedDataInWizard(double[][] aggregatedData) {
        ((SLOViewsWizard)this.getWizard()).setAggregatedData(aggregatedData);
    }

    public void setMeasurementsListAndLabel(List<Measurement> measurementsList) {
        this.measurementsList = measurementsList;
        StringBuffer label = new StringBuffer();
        for (Measurement currentMeasure : measurementsList) {
            StringMeasuringPointImpl measuringPoint = (StringMeasuringPointImpl)currentMeasure.getMeasuringType().getMeasuringPoint();
            label.append(String.valueOf(measuringPoint.getMeasuringPoint()) + "; ");
        }
        this.measuringPointsLabel = label.toString();
    }

    public void setTimestep(double timestep) {
        this.timestep = timestep;
    }

    public void setMaxSimulationTime(double max) {
        this.scale.setMaximum((int)max);
    }
}

