/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.chaindescription.ChainDescription;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamInput;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLODialogAggDataPage;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLODialogChooseMeasuringPointsPage;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLODialogChooseRepositoryPage;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLODialogChooseSLOPage;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLODialogSpecifiySLOThresholdsPage;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLOSelectDefaultCombinationsPage;

public class SLOViewsWizard
extends Wizard
implements INewWizard {
    private List<Measurement> selectedMeasurements;
    private ServiceLevelObjective selectedSLO;
    private ChainDescription selectedDefault;
    private List<ServiceLevelObjective> availableSLOs;
    private double selectedTimestepIntervalForVisualization = 10.0;
    private String measuringPointLabel = "";
    private double[][] aggregatedData;
    private boolean finishable;
    SLODialogChooseMeasuringPointsPage chooseMeasuringPointsPage;
    SLODialogChooseSLOPage chooseSLOPage;
    SLODialogSpecifiySLOThresholdsPage specifySLOPage;
    SLOSelectDefaultCombinationsPage selectDefaultCombinationsPage_SLO;
    SLODialogAggDataPage aggDataPage;
    SLODialogChooseRepositoryPage chooseRepoPage;
    private IDataSource datasource;
    private MetricDescription metricDescription;

    public SLOViewsWizard() {
        this.setWindowTitle("Service Level Objective Fulfillment Report Wizard");
        this.finishable = false;
    }

    public SLOViewsWizard(List<JFreeChartVisualizationSingleDatastreamInput> inputs) {
        for (JFreeChartVisualizationSingleDatastreamInput stream : inputs) {
            this.datasource = stream.getDataSource();
            this.metricDescription = stream.getDataSource().getMetricDesciption();
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        return this.canFinish();
    }

    public void addPages() {
        this.chooseRepoPage = new SLODialogChooseRepositoryPage("choose repo", this.metricDescription);
        this.chooseRepoPage.setSelectedMeasurements(this.selectedMeasurements);
        this.addPage((IWizardPage)this.chooseRepoPage);
        this.chooseSLOPage = new SLODialogChooseSLOPage("choose SLO");
        this.addPage((IWizardPage)this.chooseSLOPage);
        this.aggDataPage = new SLODialogAggDataPage("aggregate data");
        this.addPage((IWizardPage)this.aggDataPage);
        this.specifySLOPage = new SLODialogSpecifiySLOThresholdsPage("specify");
        this.addPage((IWizardPage)this.specifySLOPage);
        this.selectDefaultCombinationsPage_SLO = new SLOSelectDefaultCombinationsPage("specify");
        this.addPage((IWizardPage)this.selectDefaultCombinationsPage_SLO);
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage == this.chooseRepoPage && this.availableSLOs != null) {
            this.chooseSLOPage.setAvailableSLOs(this.availableSLOs);
            return this.chooseSLOPage;
        }
        if (currentPage == this.chooseSLOPage && this.selectedSLO != null) {
            this.specifySLOPage.setSelectedSLO(this.selectedSLO);
            double maxSimTime = this.aggregatedData != null ? this.aggregatedData[0][this.aggregatedData[0].length - 1] : this.calculateMaxSimulationTime(this.selectedMeasurements);
            this.specifySLOPage.setMaxSimulationTime(maxSimTime);
            this.setFinishable(true);
            return this.specifySLOPage;
        }
        if (currentPage == this.specifySLOPage) {
            this.setFinishable(true);
        }
        if (currentPage == this.selectDefaultCombinationsPage_SLO && this.selectedDefault.getChainID().contains("SLO")) {
            this.chooseRepoPage.setSelectedMeasurements(this.selectedMeasurements);
            return this.chooseRepoPage;
        }
        return null;
    }

    private double calculateMaxSimulationTime(List<Measurement> measurements) {
        return this.datasource.getDataStream().size();
    }

    public boolean canAccept(IDataSource source) {
        BaseMetricDescription[] mds = MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)source.getMetricDesciption());
        if (mds.length != 2) {
            return false;
        }
        BaseMetricDescription[] baseMetricDescriptionArray = mds;
        int n = mds.length;
        int n2 = 0;
        while (n2 < n) {
            BaseMetricDescription md = baseMetricDescriptionArray[n2];
            if (!(md instanceof NumericalBaseMetricDescription)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean canFinish() {
        return this.finishable;
    }

    public void setFinishable(boolean finishable) {
        this.finishable = finishable;
    }

    public List<Measurement> getSelectedMeasurements() {
        return this.selectedMeasurements;
    }

    public void setSelectedMeasurements(List<Measurement> selectedMeasurements) {
        if (selectedMeasurements == null) {
            selectedMeasurements = new ArrayList<Measurement>();
            this.selectedMeasurements = selectedMeasurements;
        } else {
            this.selectedMeasurements = selectedMeasurements;
        }
    }

    public ServiceLevelObjective getSelectedSLO() {
        return this.selectedSLO;
    }

    public void setSelectedSLO(ServiceLevelObjective selectedSLO) {
        this.selectedSLO = selectedSLO;
    }

    public ChainDescription getSelectedDefault() {
        return this.selectedDefault;
    }

    public void setSelectedDefault(ChainDescription selectedDefault) {
        this.selectedDefault = selectedDefault;
    }

    public List<ServiceLevelObjective> getAvailableSLOs() {
        return this.availableSLOs;
    }

    public void setAvailableSLOs(List<ServiceLevelObjective> availableSLOs) {
        this.availableSLOs = availableSLOs;
    }

    public void setAggregatedData(double[][] aggregatedData) {
        this.aggregatedData = aggregatedData;
    }

    public double[][] getAggregatedData() {
        if (this.aggregatedData != null) {
            return this.aggregatedData;
        }
        return null;
    }

    public double getSelectedTimestepInterval() {
        return this.selectedTimestepIntervalForVisualization;
    }

    public void setSelectedTimestepInterval(double selectedTimestepInterval) {
        this.selectedTimestepIntervalForVisualization = selectedTimestepInterval;
    }

    public void setMeasuringPointLabel(String label) {
        this.measuringPointLabel = label;
    }

    public String getMeasuringPointLabel() {
        return this.measuringPointLabel;
    }
}

