/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLOViewsWizard;

public class SLODialogChooseSLOPage
extends WizardPage
implements ISelectionChangedListener {
    private TableViewer choiceViewer;
    private List<ServiceLevelObjective> availableSLOs = new ArrayList<ServiceLevelObjective>();
    private IStatus selectionStatus;
    private final Status statusOK;

    protected SLODialogChooseSLOPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.setDescription("Please select one Service Level Objective for visualization.");
        this.selectionStatus = new Status(1, "not_used", 0, "Please select one Service Level Objective for visualization.", null);
        this.statusOK = new Status(0, "not_used", 0, "", null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        label.setText("Available Choices:");
        SashForm sashForm = new SashForm(composite, 256);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        sashForm.setLayoutData((Object)gd);
        this.choiceViewer = new TableViewer((Composite)sashForm, 2048);
        this.initializeChoiceViewer();
        this.setControl((Control)composite);
    }

    private void initializeChoiceViewer() {
        this.choiceViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return SLODialogChooseSLOPage.this.availableSLOs.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.choiceViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element != null) {
                    ServiceLevelObjective sequenceElement = (ServiceLevelObjective)element;
                    StringBuffer result = new StringBuffer();
                    result.append("Service Level Objective: " + sequenceElement.getName());
                    return result.toString();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.choiceViewer.setInput(this.availableSLOs);
        this.choiceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionStatus = this.statusOK;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.selectionStatus = new Status(4, "not_used", 0, "Please select a Visualization to proceed.", null);
        } else {
            ServiceLevelObjective slo = (ServiceLevelObjective)selection.getFirstElement();
            this.setSelectedSLOInWizard(slo);
            this.selectionStatus = this.statusOK;
        }
        this.updatePageStatus();
    }

    public IStatus updatePageStatus() {
        Status pageStatus = this.statusOK;
        ((SLOViewsWizard)this.getWizard()).setFinishable(false);
        switch (this.selectionStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage());
                pageStatus = this.statusOK;
                this.setPageComplete(true);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 2);
                pageStatus = this.selectionStatus;
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 1);
                pageStatus = this.selectionStatus;
                break;
            }
            default: {
                this.setErrorMessage(this.selectionStatus.getMessage());
                this.setMessage(null);
                pageStatus = this.selectionStatus;
            }
        }
        this.getContainer().updateButtons();
        return pageStatus;
    }

    private void setSelectedSLOInWizard(ServiceLevelObjective slo) {
        ((SLOViewsWizard)this.getWizard()).setSelectedSLO(slo);
    }

    public void setAvailableSLOs(List<ServiceLevelObjective> availableSLOs) {
        this.availableSLOs = availableSLOs;
        this.initializeChoiceViewer();
    }
}

