/*
 * Decompiled with CFR 0.152.
 */
package scheduler.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResourceInstanceSelection implements Enumerator
{
    ROUND_ROBIN(0, "ROUND_ROBIN", "ROUND_ROBIN"),
    PREFER_IDLE(1, "PREFER_IDLE", "PREFER_IDLE");

    public static final int ROUND_ROBIN_VALUE = 0;
    public static final int PREFER_IDLE_VALUE = 1;
    private static final ResourceInstanceSelection[] VALUES_ARRAY;
    public static final List<ResourceInstanceSelection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResourceInstanceSelection[]{ROUND_ROBIN, PREFER_IDLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResourceInstanceSelection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceInstanceSelection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceInstanceSelection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceInstanceSelection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceInstanceSelection get(int value) {
        switch (value) {
            case 0: {
                return ROUND_ROBIN;
            }
            case 1: {
                return PREFER_IDLE;
            }
        }
        return null;
    }

    private ResourceInstanceSelection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

