/*
 * Decompiled with CFR 0.152.
 */
package scheduler.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PriorityClass implements Enumerator
{
    LOWEST(0, "LOWEST", "LOWEST"),
    LOW(1, "LOW", "LOW"),
    AVERAGE(2, "AVERAGE", "AVERAGE"),
    HIGH(3, "HIGH", "HIGH"),
    HIGHEST(4, "HIGHEST", "HIGHEST"),
    DEFAULT(5, "DEFAULT", "DEFAULT");

    public static final int LOWEST_VALUE = 0;
    public static final int LOW_VALUE = 1;
    public static final int AVERAGE_VALUE = 2;
    public static final int HIGH_VALUE = 3;
    public static final int HIGHEST_VALUE = 4;
    public static final int DEFAULT_VALUE = 5;
    private static final PriorityClass[] VALUES_ARRAY;
    public static final List<PriorityClass> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PriorityClass[]{LOWEST, LOW, AVERAGE, HIGH, HIGHEST, DEFAULT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PriorityClass get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PriorityClass result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PriorityClass getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PriorityClass result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PriorityClass get(int value) {
        switch (value) {
            case 0: {
                return LOWEST;
            }
            case 1: {
                return LOW;
            }
            case 2: {
                return AVERAGE;
            }
            case 3: {
                return HIGH;
            }
            case 4: {
                return HIGHEST;
            }
            case 5: {
                return DEFAULT;
            }
        }
        return null;
    }

    private PriorityClass(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

