/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.basicqueues;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriorityManager;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessWithPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IProcessQueue;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.basicqueues.ProcessQueueImpl;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class PriorityArray
implements IProcessQueue {
    private final SchedulerModel model;
    private final Hashtable<IPriority, IProcessQueue> priorityTable;
    private final IPriorityManager priority_manager;

    public PriorityArray(SchedulerModel model, IPriorityManager priority_manager) {
        this.model = model;
        this.priority_manager = priority_manager;
        this.priorityTable = new Hashtable();
        for (IPriority prio : priority_manager.decreasing()) {
            this.priorityTable.put(prio, new ProcessQueueImpl(model));
        }
    }

    @Override
    public int size() {
        int num = 0;
        for (IProcessQueue queue : this.priorityTable.values()) {
            num += queue.size();
        }
        return num;
    }

    @Override
    public boolean isEmpty() {
        for (IProcessQueue queue : this.priorityTable.values()) {
            if (queue.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(IActiveProcess process) {
        return this.getQueueFor(process).remove(process);
    }

    @Override
    public void addLast(IActiveProcess process) {
        this.add(process, false);
    }

    @Override
    public void addFirst(IActiveProcess process) {
        this.add(process, true);
    }

    @Override
    public void add(IActiveProcess process, boolean in_front) {
        this.getQueueFor(process).add(process, in_front);
    }

    private IProcessQueue getQueueFor(IActiveProcess process) {
        assert (process instanceof ProcessWithPriority);
        return this.getQueue(((ProcessWithPriority)process).getDynamicPriority());
    }

    private IProcessQueue getNonEmptyQueueWithHighestPriority() {
        for (IPriority prio : this.priority_manager.decreasing()) {
            if (this.getQueue(prio).isEmpty()) continue;
            return this.getQueue(prio);
        }
        return null;
    }

    private IProcessQueue getQueue(IPriority prio) {
        return this.priorityTable.get(prio);
    }

    @Override
    public IProcessQueue getBestRunnableQueue(IResourceInstance instance) {
        IProcessQueue queue = null;
        for (IPriority prio : this.priority_manager.decreasing()) {
            queue = this.getQueue(prio).getBestRunnableQueue(instance);
            if (queue != null) break;
        }
        return queue;
    }

    @Override
    public IActiveProcess getNextRunnableProcess(IResourceInstance instance) {
        IActiveProcess process = null;
        for (IPriority prio : this.priority_manager.decreasing()) {
            process = this.getQueue(prio).getNextRunnableProcess();
            if (process != null) break;
        }
        return process;
    }

    @Override
    public boolean contains(IActiveProcess process) {
        for (IProcessQueue queue : this.priorityTable.values()) {
            if (!queue.contains(process)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IActiveProcess getNextRunnableProcess() {
        IProcessQueue queue = this.getNonEmptyQueueWithHighestPriority();
        if (queue != null) {
            return queue.getNextRunnableProcess();
        }
        return null;
    }

    @Override
    public void identifyMovableProcesses(IResourceInstance target_instance, boolean prio_increasing, boolean queue_ascending, int processes_needed, List<IActiveProcess> process_list) {
        Iterable<IPriority> prio_direction = prio_increasing ? this.priority_manager.increasing() : this.priority_manager.decreasing();
        for (IPriority prio : prio_direction) {
            this.getQueue(prio).identifyMovableProcesses(target_instance, prio_increasing, queue_ascending, processes_needed, process_list);
            if (process_list.size() >= processes_needed) break;
        }
    }

    @Override
    public Iterable<IActiveProcess> ascending() {
        return new Iterable<IActiveProcess>(){

            @Override
            public Iterator<IActiveProcess> iterator() {
                return new Iterator<IActiveProcess>(){
                    Iterator<IPriority> prio_iterator;
                    Iterator<IActiveProcess> queue_iterator;
                    {
                        this.prio_iterator = (this).PriorityArray.this.priority_manager.increasing().iterator();
                        this.queue_iterator = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while ((this.queue_iterator == null || !this.queue_iterator.hasNext()) && this.prio_iterator.hasNext()) {
                            this.queue_iterator = PriorityArray.this.getQueue(this.prio_iterator.next()).ascending().iterator();
                        }
                        return this.queue_iterator != null && this.queue_iterator.hasNext();
                    }

                    @Override
                    public IActiveProcess next() {
                        while ((this.queue_iterator == null || !this.queue_iterator.hasNext()) && this.prio_iterator.hasNext()) {
                            this.queue_iterator = PriorityArray.this.getQueue(this.prio_iterator.next()).ascending().iterator();
                        }
                        return this.queue_iterator == null ? null : this.queue_iterator.next();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Override
    public Iterable<IActiveProcess> descending() {
        return new Iterable<IActiveProcess>(){

            @Override
            public Iterator<IActiveProcess> iterator() {
                return new Iterator<IActiveProcess>(){
                    Iterator<IPriority> prio_iterator;
                    Iterator<IActiveProcess> queue_iterator;
                    {
                        this.prio_iterator = (this).PriorityArray.this.priority_manager.decreasing().iterator();
                        this.queue_iterator = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while ((this.queue_iterator == null || !this.queue_iterator.hasNext()) && this.prio_iterator.hasNext()) {
                            this.queue_iterator = PriorityArray.this.getQueue(this.prio_iterator.next()).descending().iterator();
                        }
                        return this.queue_iterator != null && this.queue_iterator.hasNext();
                    }

                    @Override
                    public IActiveProcess next() {
                        while ((this.queue_iterator == null || !this.queue_iterator.hasNext()) && this.prio_iterator.hasNext()) {
                            this.queue_iterator = PriorityArray.this.getQueue(this.prio_iterator.next()).descending().iterator();
                        }
                        return this.queue_iterator == null ? null : this.queue_iterator.next();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Override
    public IProcessQueue createNewInstance() {
        return new PriorityArray(this.model, this.priority_manager);
    }

    @Override
    public boolean processStarving(double threshold) {
        for (IProcessQueue q : this.priorityTable.values()) {
            if (!q.processStarving(threshold)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getWaitingTime(IActiveProcess process) {
        return this.getQueueFor(process).getWaitingTime(process);
    }

    @Override
    public void setWaitingTime(IActiveProcess process, double waiting) {
        this.getQueueFor(process).setWaitingTime(process, waiting);
    }

    @Override
    public List<IActiveProcess> getStarvingProcesses(double starvationLimit) {
        ArrayList<IActiveProcess> result = new ArrayList<IActiveProcess>();
        for (IProcessQueue q : this.priorityTable.values()) {
            result.addAll(q.getStarvingProcesses(starvationLimit));
        }
        return result;
    }
}

