/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.timeslice.impl;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.timeslice.ITimeSlice;

public class QuantumTimeSlice
implements ITimeSlice {
    protected double remaining_time;
    protected double timeslice;
    protected int remaining_quanta;
    protected int quanta;
    protected int min_quanta;

    public QuantumTimeSlice(double timeslice, int quanta, int min_quanta) {
        assert (timeslice > 0.0) : "Timeslice must be larger than 0.";
        assert (quanta > 0) : "Quanta must be larger than 0.";
        assert (min_quanta > 0) : "Min Quanta must be larger than 0.";
        this.timeslice = timeslice;
        this.quanta = quanta;
        this.min_quanta = min_quanta;
        this.remaining_time = 0.0;
        this.remaining_quanta = 0;
    }

    protected QuantumTimeSlice() {
        this.timeslice = 0.0;
        this.remaining_time = 0.0;
        this.remaining_quanta = 0;
    }

    @Override
    public boolean isFinished() {
        return MathTools.equalsDouble((double)this.remaining_time, (double)0.0);
    }

    @Override
    public void substractTime(double time) {
        this.remaining_time -= time;
        double half = this.timeslice / 2.0;
        if (this.remaining_time <= half && this.remaining_time + time > half) {
            this.remaining_quanta -= this.quanta / 2;
            if (MathTools.equalsDouble((double)this.remaining_time, (double)0.0)) {
                this.remaining_quanta = 0;
            }
        }
        assert (MathTools.lessOrEqual((double)0.0, (double)this.remaining_time)) : "Timeslice exceeded: " + this.remaining_time;
    }

    public void reset() {
        this.remaining_time = this.timeslice;
        this.remaining_quanta = this.quanta;
    }

    @Override
    public void fullReset() {
        this.remaining_time = this.timeslice;
        this.remaining_quanta = this.quanta;
    }

    @Override
    public double getRemainingTime() {
        return this.remaining_time;
    }

    @Override
    public void punish(int penalty) {
        --this.remaining_quanta;
    }

    @Override
    public void setExpired() {
        this.remaining_time = 0.0;
        this.remaining_quanta = 0;
    }

    @Override
    public ITimeSlice clone() {
        QuantumTimeSlice cts = new QuantumTimeSlice();
        cts.timeslice = this.timeslice;
        cts.quanta = this.quanta;
        cts.remaining_time = this.remaining_time;
        cts.remaining_quanta = this.remaining_quanta;
        return cts;
    }

    @Override
    public void halfReset() {
        int factor = 0;
        if (this.remaining_quanta > 4) {
            factor = 2;
        } else if (this.remaining_quanta > 1) {
            factor = 1;
        }
        this.remaining_time = this.timeslice / 2.0 * (double)factor;
    }

    @Override
    public void updateTimeForBoosting() {
        if (this.remaining_quanta < this.min_quanta) {
            this.remaining_time = 0.0;
        }
    }

    @Override
    public void updateTimeForScheduling() {
    }
}

