/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.strategies;

import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.IInstanceSelector;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.ILoadBalancer;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IQueueingStrategy;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IRunQueue;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.active.SimResourceInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

public class MultipleQueuesStrategy
implements IQueueingStrategy {
    private ILoadBalancer loadBalancer;
    private IInstanceSelector instanceSelector;
    private Hashtable<IResourceInstance, IRunQueue> runQueueTable = new Hashtable();
    private boolean in_front_when_balancing;

    public MultipleQueuesStrategy(Collection<IResourceInstance> allInstances, IRunQueue prototypeRunQueue, IInstanceSelector initialInstanceSelector, ILoadBalancer loadBalancer, boolean in_front_when_balancing) {
        this.instanceSelector = initialInstanceSelector;
        this.loadBalancer = loadBalancer;
        this.in_front_when_balancing = in_front_when_balancing;
        for (IResourceInstance resourceInstance : allInstances) {
            this.runQueueTable.put(resourceInstance, prototypeRunQueue.createNewInstance());
        }
    }

    public IRunQueue getRunQueueFor(IResourceInstance instance) {
        return this.runQueueTable.get(instance);
    }

    @Override
    public IActiveProcess getNextProcessFor(IResourceInstance instance) {
        return this.getRunQueueFor(instance).getNextRunnableProcess();
    }

    @Override
    public void addProcess(IActiveProcess process, IResourceInstance current, boolean inFront) {
        this.registerProcess(process, current);
        this.getRunQueueFor(process.getLastInstance()).addProcess(process, inFront);
    }

    public void move(IActiveProcess process, IResourceInstance src, IResourceInstance dest) {
        assert (process.getLastInstance().equals(src));
        assert (this.getRunQueueFor(src).contains(process)) : "Process '" + process + "' is not in the runqueue of '" + src + "'";
        assert (process.getRunQueue() == this.getRunQueueFor(src)) : "Invalid state of runqueues!";
        LoggingWrapper.log((String)("Moving " + process + " from " + src + " to " + dest));
        double waiting = this.getRunQueueFor(src).getWaitingTime(process);
        this.getRunQueueFor(src).removeProcess(process);
        this.getRunQueueFor(dest).addProcess(process, this.in_front_when_balancing);
        this.getRunQueueFor(dest).setWaitingTime(process, waiting);
        process.wasMovedTo(dest);
    }

    @Override
    public void activelyBalance(IResourceInstance instance) {
        this.loadBalancer.activelyBalance(instance);
    }

    public Collection<IResourceInstance> getResourceInstances() {
        return this.runQueueTable.keySet();
    }

    @Override
    public boolean isIdle(IResourceInstance instance) {
        return this.getRunQueueFor(instance).isEmpty();
    }

    public List<IResourceInstance> getIdleInstances() {
        ArrayList<IResourceInstance> idleInstances = new ArrayList<IResourceInstance>();
        for (IResourceInstance instance : this.getResourceInstances()) {
            if (!this.isIdle(instance)) continue;
            idleInstances.add(instance);
        }
        return idleInstances;
    }

    @Override
    public boolean removePendingProcess(IActiveProcess process) {
        return this.getRunQueueFor(process.getLastInstance()).removePendingProcess(process);
    }

    @Override
    public boolean containsPending(IActiveProcess process) {
        return this.getRunQueueFor(process.getLastInstance()).containsPending(process);
    }

    @Override
    public void removeRunning(IActiveProcess process) {
        this.getRunQueueFor(process.getLastInstance()).removeRunning(process);
    }

    @Override
    public IResourceInstance runningOn(IActiveProcess process) {
        for (IResourceInstance instance : this.runQueueTable.keySet()) {
            if (!this.runQueueTable.get(instance).containsRunning(process)) continue;
            return instance;
        }
        return null;
    }

    @Override
    public void setRunningOn(IActiveProcess process, IResourceInstance instance) {
        this.getRunQueueFor(instance).setRunningOn(process, instance);
    }

    @Override
    public void forkProcess(IActiveProcess process, IResourceInstance current, boolean inFront) {
        this.addProcess(process, current, inFront);
        this.loadBalancer.onFork(current);
    }

    @Override
    public void registerProcess(IActiveProcess process, IResourceInstance current) {
        IResourceInstance instance = process.getLastInstance();
        if (instance == null) {
            instance = this.instanceSelector.selectInstanceFor(process, current);
            process.setLastInstance(instance);
            process.setIdealInstance(instance);
        }
    }

    @Override
    public void fromRunningToWaiting(IActiveProcess process) {
        this.removeRunning(process);
    }

    @Override
    public void onSleep(IResourceInstance lastInstance) {
        this.loadBalancer.onSleep(lastInstance);
    }

    @Override
    public void terminateProcess(IActiveProcess process) {
        this.removePendingProcess(process);
        this.loadBalancer.onTerminate(process.getLastInstance());
    }

    @Override
    public void fromWaitingToReady(IActiveProcess process, IResourceInstance current, boolean in_front_after_waiting) {
        this.addProcess(process, current, in_front_after_waiting);
        this.loadBalancer.onWake(current);
    }

    @Override
    public List<IActiveProcess> getStarvingProcesses(IResourceInstance instance, double starvationLimit) {
        IRunQueue runQ = this.getRunQueueFor(instance);
        return runQ.getStarvingProcesses(starvationLimit);
    }

    @Override
    public void resetStarvationInfo() {
        for (IRunQueue q : this.runQueueTable.values()) {
            q.resetStarvationInfo();
        }
    }

    @Override
    public int getQueueLengthFor(SimResourceInstance simResourceInstance) {
        return this.getRunQueueFor(simResourceInstance).getCurrentLoad();
    }
}

