/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.strategies;

import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.IInstanceSelector;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.IProcessSelector;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IQueueingStrategy;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IRunQueue;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.active.SimResourceInstance;
import java.util.List;

public class SingleQueueStrategy
implements IQueueingStrategy {
    private IRunQueue runQueue;
    private IProcessSelector processSelector;
    private IInstanceSelector idealInstanceSelector;

    public SingleQueueStrategy(IRunQueue runQueue, IProcessSelector processSelector, IInstanceSelector idealInstanceSelector) {
        this.runQueue = runQueue;
        this.processSelector = processSelector;
        this.idealInstanceSelector = idealInstanceSelector;
    }

    @Override
    public IActiveProcess getNextProcessFor(IResourceInstance instance) {
        return this.processSelector.select(this.runQueue, instance);
    }

    @Override
    public void registerProcess(IActiveProcess process, IResourceInstance current) {
        IResourceInstance instance = process.getLastInstance();
        if (instance == null) {
            instance = this.idealInstanceSelector.selectInstanceFor(process, current);
            process.setLastInstance(instance);
        }
    }

    @Override
    public void addProcess(IActiveProcess process, IResourceInstance current, boolean inFront) {
        this.registerProcess(process, current);
        this.runQueue.addProcess(process, inFront);
    }

    @Override
    public void activelyBalance(IResourceInstance instance) {
    }

    @Override
    public boolean removePendingProcess(IActiveProcess process) {
        return this.runQueue.removePendingProcess(process);
    }

    @Override
    public boolean containsPending(IActiveProcess process) {
        return this.runQueue.containsPending(process);
    }

    @Override
    public void removeRunning(IActiveProcess process) {
        this.runQueue.removeRunning(process);
    }

    @Override
    public IResourceInstance runningOn(IActiveProcess process) {
        return this.runQueue.runningOn(process);
    }

    @Override
    public void setRunningOn(IActiveProcess process, IResourceInstance instance) {
        this.runQueue.setRunningOn(process, instance);
    }

    @Override
    public boolean isIdle(IResourceInstance instance) {
        return this.runQueue.isIdle(instance);
    }

    @Override
    public void forkProcess(IActiveProcess process, IResourceInstance current, boolean inFront) {
        this.addProcess(process, current, inFront);
    }

    @Override
    public void fromRunningToWaiting(IActiveProcess process) {
        this.removeRunning(process);
    }

    @Override
    public void fromWaitingToReady(IActiveProcess process, IResourceInstance current, boolean in_front_after_waiting) {
        this.addProcess(process, current, in_front_after_waiting);
    }

    @Override
    public void terminateProcess(IActiveProcess process) {
        this.removePendingProcess(process);
    }

    @Override
    public void onSleep(IResourceInstance lastInstance) {
    }

    @Override
    public List<IActiveProcess> getStarvingProcesses(IResourceInstance instance, double starvationLimit) {
        return this.runQueue.getStarvingProcesses(starvationLimit);
    }

    @Override
    public void resetStarvationInfo() {
        this.runQueue.resetStarvationInfo();
    }

    @Override
    public int getQueueLengthFor(SimResourceInstance simResourceInstance) {
        return this.runQueue.getCurrentLoad();
    }
}

