/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive;

import de.uka.ipd.sdq.scheduler.IRunningProcess;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.resources.passive.PassiveResourceObservee;
import de.uka.ipd.sdq.scheduler.sensors.IPassiveResourceSensor;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.SimActiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriorityBoost;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.PreemptiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessWithPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive.SimAbstractPassiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive.WaitingProcess;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;

public class SimFairPassiveResource
extends SimAbstractPassiveResource {
    private final PassiveResourceObservee observee = new PassiveResourceObservee();
    private long available;

    public SimFairPassiveResource(SchedulerModel model, long capacity, PassiveResource resource, IPriorityBoost priority_boost, SimActiveResource managing_resource, AssemblyContext assemblyContext) {
        super(model, capacity, resource, priority_boost, managing_resource, assemblyContext);
        this.available = capacity;
    }

    private boolean canProceed(IRunningProcess process, long num) {
        return (this.waiting_queue.isEmpty() || ((WaitingProcess)this.waiting_queue.peek()).getActiveProcess().equals(process)) && num <= this.available;
    }

    public boolean acquire(ISchedulableProcess sched_process, long num, boolean timeout, double timeoutValue) {
        if (!this.getModel().getSimulationControl().isRunning()) {
            return true;
        }
        this.observee.fireRequest(sched_process, num);
        PreemptiveProcess process = (PreemptiveProcess)this.main_resource.lookUp(sched_process);
        if (this.canProceed(process, num)) {
            this.grantAccess(process, num);
            return true;
        }
        LoggingWrapper.log((String)("Process " + process + " is waiting for " + num + " of " + (Object)((Object)this)));
        WaitingProcess waiting_process = new WaitingProcess(process, num);
        this.fromRunningToWaiting(waiting_process, false);
        process.getSchedulableProcess().passivate();
        return false;
    }

    public void release(ISchedulableProcess sched_process, long num) {
        if (!this.getModel().getSimulationControl().isRunning()) {
            return;
        }
        IActiveProcess process = this.main_resource.lookUp(sched_process);
        LoggingWrapper.log((String)("Process " + process + " releases " + num + " of " + (Object)((Object)this)));
        this.available += num;
        this.observee.fireRelease(sched_process, num);
        this.notifyWaitingProcesses(process.getLastInstance());
    }

    private void notifyWaitingProcesses(IResourceInstance current) {
        WaitingProcess waitingProcess = (WaitingProcess)this.waiting_queue.peek();
        if (waitingProcess != null && this.tryToDequeueProcess(waitingProcess)) {
            this.fromWaitingToReady(waitingProcess, current);
        }
    }

    private void grantAccess(PreemptiveProcess process, long num) {
        LoggingWrapper.log((String)("Process " + process + " acquires " + num + " of " + (Object)((Object)this)));
        this.punish(process);
        this.boostPriority(process);
        this.available -= num;
        this.observee.fireAquire(process.getSchedulableProcess(), num);
        assert (this.available >= 0L) : "More resource than available have been acquired!";
    }

    private boolean tryToDequeueProcess(WaitingProcess waitingProcess) {
        if (this.canProceed(waitingProcess.getActiveProcess(), waitingProcess.getNumRequested())) {
            this.grantAccess((ProcessWithPriority)waitingProcess.getActiveProcess(), waitingProcess.getNumRequested());
            return true;
        }
        return false;
    }

    public void addObserver(IPassiveResourceSensor observer) {
        this.observee.addObserver(observer);
    }

    public void removeObserver(IPassiveResourceSensor observer) {
        this.observee.removeObserver(observer);
    }

    public long getAvailable() {
        return this.available;
    }
}

