/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.strategy.impl;

import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.processes.IWaitingProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.SimActiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.PreemptiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IQueueingStrategy;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive.WaitingProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.strategy.IScheduler;
import java.util.Deque;
import scheduler.configuration.StarvationBoost;

public abstract class AbstractScheduler
implements IScheduler {
    protected SimActiveResource resource;
    protected IQueueingStrategy queueing_strategy;
    private boolean in_front_after_waiting;
    protected double scheduling_interval;
    protected StarvationBoost starvationBoost;

    public AbstractScheduler(SimActiveResource resource, IQueueingStrategy queueingStrategy, boolean in_front_after_waiting, StarvationBoost starvationBoost) {
        this.resource = resource;
        this.queueing_strategy = queueingStrategy;
        this.in_front_after_waiting = in_front_after_waiting;
        this.starvationBoost = starvationBoost;
    }

    @Override
    public void forkNewProcess(IActiveProcess process, IResourceInstance current) {
        this.queueing_strategy.forkProcess(process, current, false);
    }

    @Override
    public void registerProcess(IActiveProcess p, IResourceInstance instance) {
        this.queueing_strategy.registerProcess(p, instance);
    }

    @Override
    public void terminateProcess(IActiveProcess process, IResourceInstance current) {
        if (process.isRunning()) {
            this.fromRunningToReady(process, current, true);
            this.queueing_strategy.terminateProcess(process);
            process.getLastInstance().schedulingInterrupt(0.0);
        } else {
            this.queueing_strategy.terminateProcess(process);
        }
    }

    protected void fromReadyToRunningOn(IActiveProcess process, IResourceInstance instance) {
        LoggingWrapper.log((String)(" From READY to RUNNING " + process + " on " + instance));
        assert (process != null);
        assert (process.isReady());
        assert (this.queueing_strategy.containsPending(process));
        assert (!instance.processAssigned());
        this.queueing_strategy.removePendingProcess(process);
        process.setRunning();
        this.queueing_strategy.setRunningOn(process, instance);
        instance.assign(process);
        process.setLastInstance(instance);
    }

    protected void fromRunningToReady(IActiveProcess process, IResourceInstance current, boolean inFront) {
        LoggingWrapper.log((String)(" From RUNNING to READY Process " + process));
        assert (process.isRunning()) : "Process must be in running state to return to pending queue!";
        assert (this.queueing_strategy.runningOn(process).equals(process.getLastInstance())) : "Inconstistant State of the last instance of the process.";
        assert (process.getLastInstance().getRunningProcess().equals(process)) : "Inconsistent running state!";
        this.queueing_strategy.removeRunning(process);
        this.stopProcess(process);
        process.setReady();
        this.queueing_strategy.addProcess(process, current, inFront);
    }

    @Override
    public void fromRunningToWaiting(WaitingProcess waiting_process, Deque<IWaitingProcess> waiting_queue, boolean in_front) {
        LoggingWrapper.log((String)(" From RUNNING to WAITING Process " + waiting_process.getProcess()));
        IActiveProcess process = waiting_process.getActiveProcess();
        assert (process.isRunning()) : "Process must be in running state.";
        this.queueing_strategy.fromRunningToWaiting(process);
        this.stopProcess(process);
        process.setWaiting();
        if (in_front) {
            waiting_queue.addFirst(waiting_process);
        } else {
            waiting_queue.addLast(waiting_process);
        }
        process.getLastInstance().schedulingInterrupt(0.0);
        this.queueing_strategy.onSleep(process.getLastInstance());
    }

    private void stopProcess(IActiveProcess process) {
        process.getLastInstance().release();
        process.cancelProceedEvent();
    }

    @Override
    public void fromWaitingToReady(WaitingProcess waiting_process, Deque<IWaitingProcess> waitingQueue, IResourceInstance current) {
        LoggingWrapper.log((String)("From WAITING to READY Process " + waiting_process.getProcess()));
        IActiveProcess process = waiting_process.getActiveProcess();
        assert (process.isWaiting()) : "Process must be in waiting state";
        waitingQueue.remove(waiting_process);
        process.setReady();
        ((PreemptiveProcess)process).getTimeslice().updateTimeForScheduling();
        this.queueing_strategy.fromWaitingToReady(process, current, this.in_front_after_waiting);
        process.toNow();
        process.update();
        process.getLastInstance().schedulingInterrupt(0.0);
    }
}

