/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.jobs;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.CalculatorHelper;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedResourceContainer;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.SimActiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.boost.StaticPriorityBoost;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.update.DecayToBaseUpdate;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive.SimFairPassiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive.SimUnfairPassiveResource;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;

public class ResourceContainerWrapper
extends SimulatedResourceContainer {
    public static final String SCHEDULING_STRATEGY_EXACT_WINXP = "edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.winxp";
    public static final String SCHEDULING_STRATEGY_EXACT_WIN7 = "edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.win7";
    public static final String SCHEDULING_STRATEGY_EXACT_WINVISTA = "edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.winvista";
    public static final String SCHEDULING_STRATEGY_EXACT_WINSERVER2003 = "edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.winserver2003";
    public static final String SCHEDULING_STRATEGY_EXACT_LINUX26O1 = "edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.linux26o1";
    public static final String SCHEDULING_STRATEGY_EXACT_LINUXCFS = "edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.linux26cfs";
    AbstractSimulatedResourceContainer originalResourceContainer = null;
    private String cpuSchedulingStrategy = null;
    private String cpuResourceId = null;

    public ResourceContainerWrapper(SimuComModel myModel, String myContainerID, AbstractSimulatedResourceContainer originalResourceContainer, String cpuResourceId, String cpuSchedulingStrategy) {
        super(myModel, myContainerID, ((SimulatedResourceContainer)originalResourceContainer).getNestedResourceContainers(), ((SimulatedResourceContainer)originalResourceContainer).getParentResourceContainer());
        this.cpuSchedulingStrategy = cpuSchedulingStrategy;
        this.cpuResourceId = cpuResourceId;
        this.originalResourceContainer = originalResourceContainer;
        this.activeResources = originalResourceContainer.getAllActiveResources();
    }

    public void loadActiveResource(SimuComSimProcess requestingProcess, String typeID, double demand) {
        this.originalResourceContainer.loadActiveResource(requestingProcess, typeID, demand);
    }

    public void loadActiveResource(SimuComSimProcess requestingProcess, String providedInterfaceID, int resourceServiceID, double demand) {
        this.originalResourceContainer.loadActiveResource(requestingProcess, providedInterfaceID, resourceServiceID, demand);
    }

    public IPassiveResource createPassiveResource(PassiveResource resource, AssemblyContext assemblyContext, long capacity) {
        IPassiveResource r = null;
        if (this.cpuSchedulingStrategy.equals(SCHEDULING_STRATEGY_EXACT_WINXP) || this.cpuSchedulingStrategy.equals(SCHEDULING_STRATEGY_EXACT_WIN7) || this.cpuSchedulingStrategy.equals(SCHEDULING_STRATEGY_EXACT_WINVISTA) || this.cpuSchedulingStrategy.equals(SCHEDULING_STRATEGY_EXACT_WINSERVER2003)) {
            r = this.getPassiveResourceWindows(resource, capacity, 1, true, true, ((AbstractScheduledResource)this.activeResources.get(this.cpuResourceId)).getScheduledResource(), assemblyContext);
            CalculatorHelper.setupWaitingTimeCalculator((IPassiveResource)r, (SimuComModel)this.myModel);
            CalculatorHelper.setupHoldTimeCalculator((IPassiveResource)r, (SimuComModel)this.myModel);
            return r;
        }
        if (this.cpuSchedulingStrategy.equals(SCHEDULING_STRATEGY_EXACT_LINUX26O1)) {
            r = this.getPassiveResourceLinux(resource, capacity, true, ((AbstractScheduledResource)this.activeResources.get(this.cpuResourceId)).getScheduledResource(), assemblyContext);
            CalculatorHelper.setupWaitingTimeCalculator((IPassiveResource)r, (SimuComModel)this.myModel);
            CalculatorHelper.setupHoldTimeCalculator((IPassiveResource)r, (SimuComModel)this.myModel);
            return r;
        }
        return super.createPassiveResource(resource, assemblyContext, capacity);
    }

    private IPassiveResource getPassiveResourceWindows(PassiveResource resource, long capacity, int bonus, boolean resetTimeSlice, boolean isFair, IActiveResource managingResource, AssemblyContext assemblyContext) {
        DecayToBaseUpdate update = new DecayToBaseUpdate();
        StaticPriorityBoost boost = new StaticPriorityBoost(update, bonus, 0, resetTimeSlice);
        if (isFair) {
            return new SimFairPassiveResource((SchedulerModel)this.myModel, capacity, resource, boost, (SimActiveResource)managingResource, assemblyContext);
        }
        return new SimUnfairPassiveResource((SchedulerModel)this.myModel, capacity, resource, boost, (SimActiveResource)managingResource, 0.1, true, assemblyContext);
    }

    private IPassiveResource getPassiveResourceLinux(PassiveResource resource, long capacity, boolean isFair, IActiveResource managingResource, AssemblyContext assemblyContext) {
        if (isFair) {
            return new SimFairPassiveResource((SchedulerModel)this.myModel, capacity, resource, null, (SimActiveResource)managingResource, assemblyContext);
        }
        return new SimUnfairPassiveResource((SchedulerModel)this.myModel, capacity, resource, null, (SimActiveResource)managingResource, 0.1, true, assemblyContext);
    }
}

