/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.impl;

import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriorityManager;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.impl.PriorityImpl;
import java.util.Iterator;

public class PriorityManagerImpl
implements IPriorityManager {
    protected IPriority highestPriority;
    protected IPriority highPriority;
    protected IPriority averagePriority;
    protected IPriority lowPriority;
    protected IPriority lowestPriority;
    protected IPriority defaultPriority;
    protected int direction;
    protected int highest_value;
    protected int lowest_value;

    public PriorityManagerImpl(int highest_value, int high_value, int average_value, int low_value, int lowest_value, int default_value) {
        assert (highest_value >= high_value && high_value >= average_value && average_value >= low_value && low_value >= lowest_value || highest_value <= high_value && high_value <= average_value && average_value <= low_value && low_value <= lowest_value) : "Priorities must be ordered!";
        this.direction = highest_value > lowest_value ? 1 : -1;
        this.highest_value = highest_value;
        this.lowest_value = lowest_value;
        this.highestPriority = new PriorityImpl(highest_value, this);
        this.highPriority = new PriorityImpl(high_value, this);
        this.averagePriority = new PriorityImpl(average_value, this);
        this.lowPriority = new PriorityImpl(low_value, this);
        this.lowestPriority = new PriorityImpl(lowest_value, this);
        this.defaultPriority = new PriorityImpl(default_value, this);
    }

    @Override
    public Iterable<IPriority> decreasing() {
        return new Iterable<IPriority>(){

            @Override
            public Iterator<IPriority> iterator() {
                return new Iterator<IPriority>(){
                    IPriority current;
                    {
                        this.current = (this).PriorityManagerImpl.this.highestPriority.clone();
                    }

                    @Override
                    public boolean hasNext() {
                        return (this).PriorityManagerImpl.this.lowestPriority.lessOrEqual(this.current);
                    }

                    @Override
                    public IPriority next() {
                        IPriority result = this.current;
                        this.current = this.current.decrease();
                        return result;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Override
    public Iterable<IPriority> increasing() {
        return new Iterable<IPriority>(){

            @Override
            public Iterator<IPriority> iterator() {
                return new Iterator<IPriority>(){
                    IPriority current;
                    {
                        this.current = (this).PriorityManagerImpl.this.lowestPriority.clone();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current.lessOrEqual((this).PriorityManagerImpl.this.highestPriority);
                    }

                    @Override
                    public IPriority next() {
                        IPriority result = this.current;
                        this.current = this.current.increase();
                        return result;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Override
    public IPriority getDefaultPriority() {
        return this.defaultPriority.clone();
    }

    @Override
    public IPriority getHighestPriority() {
        return this.highestPriority.clone();
    }

    @Override
    public IPriority getLowestPriority() {
        return this.lowestPriority.clone();
    }

    @Override
    public IPriority getAveragePriority() {
        return this.averagePriority.clone();
    }

    @Override
    public IPriority getHighPriority() {
        return this.highPriority.clone();
    }

    @Override
    public IPriority getLowPriority() {
        return this.lowPriority.clone();
    }
}

