/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.entities.SchedulerEntity;
import de.uka.ipd.sdq.scheduler.processes.PROCESS_STATE;
import de.uka.ipd.sdq.scheduler.sensors.IProcessStateSensor;
import de.uka.ipd.sdq.simulation.abstractsimengine.IEntity;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.events.IDelayedAction;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.events.ProceedEvent;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.IResourceInstanceConstraint;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.constraints.MultipleResourceInstancesConstraint;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.loaddistribution.constraints.SingleResourceInstanceConstraint;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IRunQueue;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.strategy.IScheduler;
import java.util.ArrayList;
import java.util.List;

public class ActiveProcess
extends SchedulerEntity
implements IActiveProcess {
    private final ISchedulableProcess process;
    private IRunQueue runqueue;
    private PROCESS_STATE state = PROCESS_STATE.READY;
    private final List<IProcessStateSensor> processStateSensorList;
    private double currentDemand = 0.0;
    private double lastUpdateTime = 0.0;
    private MultipleResourceInstancesConstraint affinityConstraint = null;
    private SingleResourceInstanceConstraint idealInstanceConstraint = null;
    private SingleResourceInstanceConstraint lastInstanceConstraint = null;
    private boolean just_blanced = false;
    private ProceedEvent proceedEvent = null;

    public ActiveProcess(SchedulerModel model, ISchedulableProcess process) {
        super(model, ActiveProcess.class.getName());
        this.proceedEvent = new ProceedEvent(model);
        this.process = process;
        this.processStateSensorList = new ArrayList<IProcessStateSensor>();
        this.runqueue = null;
        this.state = PROCESS_STATE.READY;
    }

    @Override
    public void update() {
    }

    @Override
    public IRunQueue getRunQueue() {
        return this.runqueue;
    }

    @Override
    public void setRunQueue(IRunQueue runqueue) {
        this.runqueue = runqueue;
    }

    public ISchedulableProcess getSchedulableProcess() {
        return this.process;
    }

    public String getName() {
        return this.process.getId();
    }

    public String getId() {
        return this.process.getId();
    }

    public String toString() {
        return this.process.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActiveProcess) {
            ActiveProcess process = (ActiveProcess)obj;
            return process.getId().equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        String id = this.getId();
        int hashCode = id.hashCode();
        return hashCode;
    }

    @Override
    public PROCESS_STATE getState() {
        return this.state;
    }

    public void setState(PROCESS_STATE new_state) {
        this.state = new_state;
        for (IProcessStateSensor sensor : this.processStateSensorList) {
            sensor.update(new_state);
        }
    }

    @Override
    public void setRunning() {
        this.setState(PROCESS_STATE.RUNNING);
        this.just_blanced = false;
    }

    @Override
    public void setReady() {
        this.setState(PROCESS_STATE.READY);
    }

    @Override
    public void setWaiting() {
        this.setState(PROCESS_STATE.WAITING);
    }

    @Override
    public boolean isRunning() {
        return this.getState() == PROCESS_STATE.RUNNING;
    }

    @Override
    public boolean isReady() {
        return this.getState() == PROCESS_STATE.READY;
    }

    @Override
    public boolean isWaiting() {
        return this.getState() == PROCESS_STATE.WAITING;
    }

    public void addStateSensor(IProcessStateSensor sensor) {
        this.processStateSensorList.add(sensor);
    }

    public void removeStateSensor(IProcessStateSensor sensor) {
        this.processStateSensorList.remove(sensor);
    }

    @Override
    public double getCurrentDemand() {
        return this.currentDemand;
    }

    @Override
    public void setCurrentDemand(double currentDemand) {
        assert (MathTools.equalsDouble((double)this.currentDemand, (double)0.0)) : this.currentDemand;
        this.currentDemand = currentDemand;
    }

    @Override
    public void toNow() {
        double passedTime;
        double currentTime = this.getModel().getSimulationControl().getCurrentSimulationTime();
        if (this.isRunning() && (passedTime = currentTime - this.lastUpdateTime) > 1.0E-5) {
            this.passTimeProcessing(passedTime);
        }
        this.lastUpdateTime = currentTime;
    }

    protected void passTimeProcessing(double passedTime) {
        this.currentDemand -= passedTime;
        if (MathTools.equalsDouble((double)this.currentDemand, (double)0.0)) {
            this.currentDemand = 0.0;
        }
    }

    @Override
    public void setAffineInstances(List<IResourceInstance> instanceList) {
        this.affinityConstraint = new MultipleResourceInstancesConstraint(instanceList);
    }

    @Override
    public boolean hasAffinityList() {
        return this.affinityConstraint != null;
    }

    @Override
    public boolean checkAffinity(IResourceInstance instance) {
        return this.checkInstanceConstraint(this.affinityConstraint, instance);
    }

    @Override
    public void removeNonAffineInstances(List<IResourceInstance> instances) {
        if (this.hasAffinityList()) {
            for (IResourceInstance instance : instances) {
                if (this.affinityConstraint.check(instance)) continue;
                instances.remove(instance);
            }
        }
    }

    @Override
    public void setIdealInstance(IResourceInstance instance) {
        this.idealInstanceConstraint = instance != null ? new SingleResourceInstanceConstraint(instance) : null;
    }

    @Override
    public boolean hasIdealInstance() {
        return this.idealInstanceConstraint != null;
    }

    @Override
    public boolean isIdealInstance(IResourceInstance instance) {
        return this.checkInstanceConstraint(this.idealInstanceConstraint, instance);
    }

    @Override
    public IResourceInstance getIdealInstance() {
        if (this.hasIdealInstance()) {
            return this.idealInstanceConstraint.getResourceInstance();
        }
        return null;
    }

    @Override
    public void setLastInstance(IResourceInstance instance) {
        this.lastInstanceConstraint = instance != null ? new SingleResourceInstanceConstraint(instance) : null;
    }

    @Override
    public boolean hasLastInstance() {
        return this.lastInstanceConstraint != null;
    }

    @Override
    public IResourceInstance getLastInstance() {
        if (this.hasLastInstance()) {
            return this.lastInstanceConstraint.getResourceInstance();
        }
        return null;
    }

    @Override
    public boolean isLastInstance(IResourceInstance instance) {
        return this.checkInstanceConstraint(this.lastInstanceConstraint, instance);
    }

    private boolean checkInstanceConstraint(IResourceInstanceConstraint constraint, IResourceInstance instance) {
        if (constraint != null) {
            return constraint.check(instance);
        }
        return true;
    }

    @Override
    public boolean isMovable(IResourceInstance targetInstance) {
        return this.checkAffinity(targetInstance) && !this.just_blanced;
    }

    @Override
    public void wasMovedTo(IResourceInstance dest) {
        this.setLastInstance(dest);
        this.setIdealInstance(dest);
        this.just_blanced = true;
    }

    @Override
    public void scheduleProceedEvent(IScheduler scheduler) {
        this.cancelProceedEvent();
        this.proceedEvent.setScheduler(scheduler);
        this.proceedEvent.schedule((IEntity)this, this.getCurrentDemand());
    }

    @Override
    public void cancelProceedEvent() {
        this.proceedEvent.removeEvent();
    }

    @Override
    public double getTimeUntilNextInterruption() {
        return this.currentDemand;
    }

    @Override
    public void setDelayedAction(IDelayedAction action) {
        this.proceedEvent.setDelayedAction(action);
    }

    public IActiveProcess createNewInstance(SchedulerModel model, ISchedulableProcess process) {
        return new ActiveProcess(model, process);
    }

    @Override
    public IActiveProcess createNewInstance(ISchedulableProcess process) {
        return null;
    }
}

