/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriorityUpdateStrategy;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.PreemptiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IRunQueue;

public class ProcessWithPriority
extends PreemptiveProcess {
    private IPriority staticPriority;
    private IPriority dynamicPriority;
    private IPriorityUpdateStrategy priorityUpdateStrategy;
    private static boolean in_front_if_priority_changed = false;

    public ProcessWithPriority(SchedulerModel model, ISchedulableProcess process, IPriority staticPriority) {
        super(model, process);
        this.staticPriority = staticPriority;
        this.dynamicPriority = staticPriority;
        this.priorityUpdateStrategy = null;
    }

    public IPriority getStaticPriority() {
        return this.staticPriority;
    }

    public IPriority getDynamicPriority() {
        return this.dynamicPriority;
    }

    public void setPriorityUpdateStrategy(IPriorityUpdateStrategy priorityUpdateStrategy) {
        this.priorityUpdateStrategy = priorityUpdateStrategy;
    }

    public void updatePriority() {
        if (this.priorityUpdateStrategy != null) {
            this.priorityUpdateStrategy.update(this);
        }
    }

    public boolean hasBonus() {
        return this.dynamicPriority.greaterThan(this.staticPriority);
    }

    public void resetDynamicPriority() {
        this.changePriority(this.staticPriority);
    }

    public void decreasePriority() {
        this.changePriority(this.dynamicPriority.decrease());
    }

    public boolean setToStaticPriorityWithBonus(int bonus) {
        return this.changePriority(this.staticPriority.addBonus(bonus));
    }

    private boolean changePriority(IPriority new_priority) {
        if (!this.dynamicPriority.equals(new_priority)) {
            IRunQueue q = null;
            if (this.isReady() && (q = this.getRunQueue()) != null) {
                q.removeProcess(this);
                this.dynamicPriority = new_priority;
                q.addProcess(this, in_front_if_priority_changed);
            } else {
                this.dynamicPriority = new_priority;
            }
            return true;
        }
        return false;
    }

    @Override
    public void update() {
        super.update();
        this.updatePriority();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " (" + MathTools.round((double)this.getTimeslice().getRemainingTime(), (double)0.1) + ", " + this.getDynamicPriority() + ")";
    }

    @Override
    public IActiveProcess createNewInstance(ISchedulableProcess process) {
        ProcessWithPriority p = new ProcessWithPriority(this.getModel(), process, this.staticPriority);
        p.dynamicPriority = this.staticPriority;
        if (this.priorityUpdateStrategy != null) {
            p.priorityUpdateStrategy = this.priorityUpdateStrategy.cloneFor(p);
        }
        p.setTimeSlice(this.getTimeslice().clone());
        p.updatePriority();
        return p;
    }
}

