/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.runqueues;

import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IRunQueue;
import java.util.Hashtable;
import java.util.Map;

public abstract class AbstractRunQueue
implements IRunQueue {
    protected Map<IActiveProcess, IResourceInstance> running_on_table = new Hashtable<IActiveProcess, IResourceInstance>();

    protected AbstractRunQueue() {
    }

    @Override
    public int getCurrentLoad() {
        int running = this.running_on_table.size();
        int waiting = this.numWaitingProcesses();
        return running + waiting;
    }

    @Override
    public boolean isEmpty() {
        return this.getCurrentLoad() == 0;
    }

    @Override
    public boolean removeProcess(IActiveProcess process) {
        return this.running_on_table.remove(process) != null || this.removePendingProcess(process);
    }

    @Override
    public boolean contains(IActiveProcess process) {
        return this.running_on_table.containsKey(process) || this.containsPending(process);
    }

    @Override
    public void addProcess(IActiveProcess process, boolean inFront) {
        process.setRunQueue(this);
        this.addProcessToRunQueue(process, inFront);
    }

    @Override
    public boolean containsRunning(IActiveProcess process) {
        return this.running_on_table.containsKey(process);
    }

    @Override
    public void removeRunning(IActiveProcess process) {
        assert (this.running_on_table.containsKey(process)) : "Process '" + process + "' not running.";
        this.running_on_table.remove(process);
    }

    @Override
    public void setRunningOn(IActiveProcess process, IResourceInstance instance) {
        assert (this.running_on_table.get(process) == null);
        assert (!this.running_on_table.values().contains(instance));
        this.running_on_table.put(process, instance);
    }

    @Override
    public IResourceInstance runningOn(IActiveProcess process) {
        return this.running_on_table.get(process);
    }

    @Override
    public boolean isIdle(IResourceInstance instance) {
        return !instance.processAssigned() && (this.running_on_table.size() > 1 || this.numWaitingProcesses() == 0);
    }

    @Override
    public abstract IActiveProcess getNextRunnableProcess(IResourceInstance var1);

    @Override
    public abstract boolean containsPending(IActiveProcess var1);

    protected abstract int numWaitingProcesses();

    @Override
    public abstract boolean removePendingProcess(IActiveProcess var1);

    protected abstract void addProcessToRunQueue(IActiveProcess var1, boolean var2);
}

