/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.runqueues;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.PreemptiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IProcessQueue;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.IRunQueue;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.queueing.runqueues.AbstractRunQueue;
import java.util.ArrayList;
import java.util.List;

public class ActiveExpiredRunQueue
extends AbstractRunQueue {
    private SchedulerModel model;
    private IProcessQueue activePriorityArray;
    private IProcessQueue expiredPriorityArray;
    private double expired_timestamp = -1.0;

    public ActiveExpiredRunQueue(SchedulerModel model, IProcessQueue queue_prototype) {
        this.model = model;
        this.activePriorityArray = queue_prototype.createNewInstance();
        this.expiredPriorityArray = queue_prototype.createNewInstance();
    }

    @Override
    public void addProcessToRunQueue(IActiveProcess process, boolean inFront) {
        if (((PreemptiveProcess)process).getTimeslice().isFinished()) {
            this.updateStarvationTime();
        }
        if (process instanceof PreemptiveProcess) {
            PreemptiveProcess preemptiveProcess = (PreemptiveProcess)process;
            if (preemptiveProcess.getTimeslice().isFinished()) {
                this.expiredPriorityArray.add(process, inFront);
            } else {
                this.activePriorityArray.add(process, inFront);
            }
        } else {
            this.expiredPriorityArray.add(process, inFront);
        }
    }

    @Override
    protected int numWaitingProcesses() {
        return this.activePriorityArray.size() + this.expiredPriorityArray.size();
    }

    @Override
    public IActiveProcess getNextRunnableProcess(IResourceInstance instance) {
        if (this.activeQueueEmpty()) {
            this.switchActiveAndExpired();
        }
        if (this.activePriorityArray.isEmpty()) {
            return null;
        }
        return this.activePriorityArray.getNextRunnableProcess(instance);
    }

    @Override
    public IActiveProcess getNextRunnableProcess() {
        if (this.activeQueueEmpty()) {
            this.switchActiveAndExpired();
        }
        if (this.activePriorityArray.isEmpty()) {
            return null;
        }
        return this.activePriorityArray.getNextRunnableProcess();
    }

    private void switchActiveAndExpired() {
        IProcessQueue temp = this.activePriorityArray;
        this.activePriorityArray = this.expiredPriorityArray;
        this.expiredPriorityArray = temp;
        this.resetStarvationInfo();
    }

    @Override
    public boolean removePendingProcess(IActiveProcess process) {
        return this.activePriorityArray.remove(process) || this.expiredPriorityArray.remove(process);
    }

    protected boolean activeQueueEmpty() {
        return this.running_on_table.isEmpty() && this.activePriorityArray.isEmpty();
    }

    @Override
    public IRunQueue createNewInstance() {
        return new ActiveExpiredRunQueue(this.model, this.activePriorityArray);
    }

    @Override
    public List<IActiveProcess> identifyMovableProcesses(IResourceInstance targetInstance, boolean prio_increasing, boolean queue_ascending, int processes_needed) {
        ArrayList<IActiveProcess> process_list = new ArrayList<IActiveProcess>();
        this.expiredPriorityArray.identifyMovableProcesses(targetInstance, prio_increasing, queue_ascending, processes_needed, process_list);
        this.activePriorityArray.identifyMovableProcesses(targetInstance, prio_increasing, queue_ascending, processes_needed, process_list);
        return process_list;
    }

    @Override
    public IProcessQueue getBestRunnableQueue(IResourceInstance instance) {
        IProcessQueue result = this.activePriorityArray.getBestRunnableQueue(instance);
        if (result == null) {
            result = this.expiredPriorityArray.getBestRunnableQueue(instance);
        }
        return result;
    }

    @Override
    public boolean containsPending(IActiveProcess process) {
        return this.activePriorityArray.contains(process) || this.expiredPriorityArray.contains(process);
    }

    @Override
    public boolean processStarving(double threshold) {
        if (this.expired_timestamp >= 0.0) {
            double simTime = this.model.getSimulationControl().getCurrentSimulationTime();
            return simTime - this.expired_timestamp > threshold;
        }
        return false;
    }

    @Override
    public List<IActiveProcess> getStarvingProcesses(double starvationLimit) {
        List<IActiveProcess> result = this.expiredPriorityArray.getStarvingProcesses(starvationLimit);
        result.addAll(this.activePriorityArray.getStarvingProcesses(starvationLimit));
        return result;
    }

    @Override
    public void setWaitingTime(IActiveProcess process, double waiting) {
        if (this.expiredPriorityArray.contains(process)) {
            this.expiredPriorityArray.setWaitingTime(process, waiting);
        } else {
            this.activePriorityArray.setWaitingTime(process, waiting);
        }
    }

    @Override
    public double getWaitingTime(IActiveProcess process) {
        if (this.expiredPriorityArray.contains(process)) {
            return this.expiredPriorityArray.getWaitingTime(process);
        }
        return this.activePriorityArray.getWaitingTime(process);
    }

    @Override
    public void resetStarvationInfo() {
        this.expired_timestamp = -1.0;
    }

    private void updateStarvationTime() {
        double simTime = this.model.getSimulationControl().getCurrentSimulationTime();
        this.updateStarvationTime(simTime);
    }

    private void updateStarvationTime(double waiting) {
        if (this.expired_timestamp < 0.0) {
            this.expired_timestamp = waiting;
        }
    }
}

