/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.update;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriorityUpdateStrategy;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessWithPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.sensors.impl.SleepAverageSensor;

public class SleepAverageDependentUpdate
implements IPriorityUpdateStrategy {
    private SchedulerModel model;
    private SleepAverageSensor sleepAverageSensor;
    private double max_sleep_average;
    private int max_bonus;

    public SleepAverageDependentUpdate(SchedulerModel model, IActiveProcess process, double max_sleep_average, int max_bonus) {
        this.sleepAverageSensor = new SleepAverageSensor(model, process, max_sleep_average, max_bonus);
        process.addStateSensor(this.sleepAverageSensor);
        this.model = model;
        this.max_bonus = max_bonus;
        this.max_sleep_average = max_sleep_average;
    }

    @Override
    public boolean update(ProcessWithPriority process) {
        int current_bonus = this.sleepAverageSensor.getCurrentBonus();
        process.setToStaticPriorityWithBonus(current_bonus -= this.max_bonus / 2);
        if (process.getRunQueue() != null) {
            double starvation_limit = this.max_sleep_average * (double)process.getRunQueue().getCurrentLoad();
            boolean process_starving = process.getRunQueue().processStarving(starvation_limit);
            if (this.isInteractive(process) && process.getTimeslice().isFinished() && !process_starving) {
                process.getTimeslice().fullReset();
            }
        }
        return true;
    }

    public boolean isInteractive(ProcessWithPriority p) {
        double sleep = this.sleepAverageSensor.interactiveSleep(p);
        return this.sleepAverageSensor.getSleepAverage() > sleep;
    }

    @Override
    public SleepAverageDependentUpdate cloneFor(ProcessWithPriority process) {
        return new SleepAverageDependentUpdate(this.model, process, this.max_sleep_average, this.max_bonus);
    }
}

