/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive;

import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.IRunningProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.processes.IWaitingProcess;
import de.uka.ipd.sdq.scheduler.resources.AbstractSimResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.SimActiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriorityBoost;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessWithPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive.WaitingProcess;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;

public abstract class SimAbstractPassiveResource
extends AbstractSimResource
implements IPassiveResource {
    private final IPriorityBoost priority_boost;
    protected Deque<IWaitingProcess> waiting_queue;
    protected SimActiveResource main_resource;
    private final AssemblyContext assCtx;
    private final PassiveResource passiveResouce;

    public SimAbstractPassiveResource(SchedulerModel model, long capacity, PassiveResource passiveResource, IPriorityBoost priority_boost, SimActiveResource managing_resource, AssemblyContext assCtx) {
        super(model, capacity, passiveResource.getEntityName(), passiveResource.getId());
        this.priority_boost = priority_boost;
        this.main_resource = managing_resource;
        this.waiting_queue = new ArrayDeque<IWaitingProcess>();
        this.assCtx = assCtx;
        this.passiveResouce = passiveResource;
    }

    protected void fromWaitingToReady(WaitingProcess waiting_process, IResourceInstance current) {
        if (this.main_resource != null) {
            this.main_resource.getScheduler().fromWaitingToReady(waiting_process, this.waiting_queue, current);
        }
    }

    protected void fromRunningToWaiting(WaitingProcess waiting_process, boolean inFront) {
        if (this.main_resource != null) {
            this.main_resource.getScheduler().fromRunningToWaiting(waiting_process, this.waiting_queue, inFront);
        }
    }

    protected void boostPriority(IRunningProcess process) {
        if (this.priority_boost != null) {
            assert (process instanceof ProcessWithPriority) : "If priority boosts are used only ProcessWithPriorities can be used!";
            this.priority_boost.boost((ProcessWithPriority)process);
        }
    }

    protected void punish(IRunningProcess process) {
        if (this.priority_boost != null) {
            assert (process instanceof ProcessWithPriority) : "If priority boosts are used only ProcessWithPriorities can be used!";
            this.priority_boost.punish((ProcessWithPriority)process);
        }
    }

    public Queue<IWaitingProcess> getWaitingProcesses() {
        return this.waiting_queue;
    }

    public String toString() {
        return String.valueOf(super.getName()) + "_" + super.getId();
    }

    public PassiveResource getResource() {
        return this.passiveResouce;
    }

    public AssemblyContext getAssemblyContext() {
        return this.assCtx;
    }
}

