/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.timeslice.impl;

import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.priority.IPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessWithPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.timeslice.impl.ContinuousTimeSlice;

public class PriorityDependentTimeSlice
extends ContinuousTimeSlice {
    private double min_time_to_be_scheduled;

    public PriorityDependentTimeSlice(ProcessWithPriority process, double basic_timeslice, double min_timeslice, double min_time_to_be_scheduled) {
        double computed_timeslice = PriorityDependentTimeSlice.computeTicksFromPriority(process.getStaticPriority(), basic_timeslice);
        this.timeslice = Math.max(computed_timeslice, min_timeslice);
        this.min_time_to_be_scheduled = min_time_to_be_scheduled;
    }

    public static double computeTicksFromPriority(IPriority prio, double basic_timeslice) {
        double basic = PriorityDependentTimeSlice.getBasicTimeSlice(prio, basic_timeslice);
        IPriority max_prio = prio.getManager().getHighestPriority();
        IPriority min_prio = prio.getManager().getLowestPriority();
        int distance = min_prio.distance(prio) + 1;
        double factor = (double)(min_prio.distance(max_prio) + 1) / 2.0;
        return basic * (double)distance / factor;
    }

    public static double getBasicTimeSlice(IPriority static_prio, double basicTimeslice) {
        IPriority default_prio = static_prio.getManager().getDefaultPriority();
        if (static_prio.greaterThan(default_prio)) {
            return basicTimeslice * 4.0;
        }
        return basicTimeslice;
    }

    @Override
    public void updateTimeForScheduling() {
        if (this.remaining_time < this.min_time_to_be_scheduled) {
            this.remaining_time = 0.0;
        }
    }
}

