/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.spd.triggers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LogicalOperator implements Enumerator
{
    AND(0, "AND", "AND"),
    OR(1, "OR", "OR"),
    XOR(2, "XOR", "XOR");

    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int XOR_VALUE = 2;
    private static final LogicalOperator[] VALUES_ARRAY;
    public static final List<LogicalOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LogicalOperator[]{AND, OR, XOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LogicalOperator get(String literal) {
        LogicalOperator[] logicalOperatorArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            LogicalOperator result = logicalOperatorArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static LogicalOperator getByName(String name) {
        LogicalOperator[] logicalOperatorArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            LogicalOperator result = logicalOperatorArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static LogicalOperator get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return XOR;
            }
        }
        return null;
    }

    private LogicalOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

