/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.spd.triggers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TrendPattern implements Enumerator
{
    INCREASING(0, "Increasing", "Increasing"),
    DECREASING(1, "Decreasing", "Decreasing"),
    NON_INCREASING(2, "NonIncreasing", "NonIncreasing"),
    NON_DECREASING(3, "NonDecreasing", "NonDecreasing");

    public static final int INCREASING_VALUE = 0;
    public static final int DECREASING_VALUE = 1;
    public static final int NON_INCREASING_VALUE = 2;
    public static final int NON_DECREASING_VALUE = 3;
    private static final TrendPattern[] VALUES_ARRAY;
    public static final List<TrendPattern> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TrendPattern[]{INCREASING, DECREASING, NON_INCREASING, NON_DECREASING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TrendPattern get(String literal) {
        TrendPattern[] trendPatternArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            TrendPattern result = trendPatternArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static TrendPattern getByName(String name) {
        TrendPattern[] trendPatternArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            TrendPattern result = trendPatternArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static TrendPattern get(int value) {
        switch (value) {
            case 0: {
                return INCREASING;
            }
            case 1: {
                return DECREASING;
            }
            case 2: {
                return NON_INCREASING;
            }
            case 3: {
                return NON_DECREASING;
            }
        }
        return null;
    }

    private TrendPattern(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

