/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.spd.triggers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RelationalOperator implements Enumerator
{
    LESS_THAN(0, "LessThan", "LessThan"),
    GREATER_THAN(1, "GreaterThan", "GreaterThan"),
    EQUAL_TO(2, "EqualTo", "EqualTo"),
    LESS_THAN_OR_EQUAL_TO(3, "LessThanOrEqualTo", "LessThanOrEqualTo"),
    GREATER_THAN_OR_EQUAL_TO(4, "GreaterThanOrEqualTo", "GreaterThanOrEqualTo");

    public static final int LESS_THAN_VALUE = 0;
    public static final int GREATER_THAN_VALUE = 1;
    public static final int EQUAL_TO_VALUE = 2;
    public static final int LESS_THAN_OR_EQUAL_TO_VALUE = 3;
    public static final int GREATER_THAN_OR_EQUAL_TO_VALUE = 4;
    private static final RelationalOperator[] VALUES_ARRAY;
    public static final List<RelationalOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RelationalOperator[]{LESS_THAN, GREATER_THAN, EQUAL_TO, LESS_THAN_OR_EQUAL_TO, GREATER_THAN_OR_EQUAL_TO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RelationalOperator get(String literal) {
        RelationalOperator[] relationalOperatorArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            RelationalOperator result = relationalOperatorArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static RelationalOperator getByName(String name) {
        RelationalOperator[] relationalOperatorArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            RelationalOperator result = relationalOperatorArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static RelationalOperator get(int value) {
        switch (value) {
            case 0: {
                return LESS_THAN;
            }
            case 1: {
                return GREATER_THAN;
            }
            case 2: {
                return EQUAL_TO;
            }
            case 3: {
                return LESS_THAN_OR_EQUAL_TO;
            }
            case 4: {
                return GREATER_THAN_OR_EQUAL_TO;
            }
        }
        return null;
    }

    private RelationalOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

