/*
 * generated by Xtext 2.10.0
 */
package com.palladiosimulator.textual.repository.generator

import com.palladiosimulator.textual.repository.repoLang.Component
import com.palladiosimulator.textual.repository.repoLang.Interface
import com.palladiosimulator.textual.repository.repoLang.Repository
import com.palladiosimulator.textual.repository.repoLang.RoleSpecification
import com.palladiosimulator.textual.repository.repoLang.Signature
import com.palladiosimulator.textual.repository.repoLang.SignatureParameter
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import org.palladiosimulator.pcm.repository.RepositoryFactory
import org.palladiosimulator.pcm.repository.PrimitiveDataType
import org.palladiosimulator.pcm.repository.CompositeDataType
import org.palladiosimulator.pcm.repository.CollectionDataType
import org.palladiosimulator.pcm.repository.DataType
import org.palladiosimulator.pcm.repository.InnerDeclaration
import com.palladiosimulator.textual.repository.repoLang.PassiveResource
import org.palladiosimulator.pcm.core.CoreFactory
import com.palladiosimulator.textual.repository.repoLang.Seff
import org.palladiosimulator.pcm.seff.SeffFactory
import java.util.Collection
import org.palladiosimulator.pcm.seff.AbstractAction
import org.eclipse.emf.common.util.EList
import com.palladiosimulator.textual.repository.repoLang.SeffAction
import java.util.ArrayList
import com.palladiosimulator.textual.repository.repoLang.SeffInternalAction
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand
import org.palladiosimulator.pcm.seff.seff_performance.SeffPerformanceFactory
import com.palladiosimulator.textual.repository.repoLang.SeffExternalCallAction
import com.palladiosimulator.textual.repository.repoLang.SeffProbabilisticBranchAction
import com.palladiosimulator.textual.repository.repoLang.SeffGuardedBranchAction
import com.palladiosimulator.textual.repository.repoLang.SeffForkAction
import com.palladiosimulator.textual.repository.repoLang.SeffReleaseAction
import com.palladiosimulator.textual.repository.repoLang.SeffAcquireAction
import com.palladiosimulator.textual.repository.repoLang.SeffProbabilisticBranch
import com.palladiosimulator.textual.repository.repoLang.SeffGuardedBranch
import com.palladiosimulator.textual.repository.repoLang.SubSeff
import com.palladiosimulator.textual.repository.repoLang.SeffFork
import com.palladiosimulator.textual.repository.repoLang.SeffLoopAction
import org.palladiosimulator.pcm.parameter.ParameterFactory
import com.palladiosimulator.textual.repository.repoLang.SeffCallParameter
import com.palladiosimulator.textual.repository.repoLang.SeffVariableChar
import de.uka.ipd.sdq.stoex.StoexFactory
import com.palladiosimulator.textual.repository.repoLang.SeffReturnParameter
import com.palladiosimulator.textual.repository.repoLang.SeffSetReturnAction
import com.palladiosimulator.textual.repository.repoLang.SeffReferenceParameter
import com.palladiosimulator.textual.repository.repoLang.SeffSetVariableAction

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
class RepoLangGenerator extends AbstractGenerator {


	override void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {

		val repo = resource.allContents.filter(typeof(Repository)).map[transform]

		if (!repo.empty){
	       	val resSet = new ResourceSetImpl();
        	val path = fsa.getURI("default.repository")
  			val saveRes = resSet.createResource(path);
  			saveRes.getContents().add(repo.head);	
			saveRes.save({})

		}
		
	}
	
	def create RepositoryFactory.eINSTANCE.createRepository transform(Repository r) {
		entityName = r.name
		repositoryDescription = "Generated Repository"
		interfaces__Repository.addAll(r.elements.filter(typeof(Interface)).map[transform]) 
		components__Repository.addAll(r.elements.filter(typeof(Component)).map[transform])
		dataTypes__Repository.addAll(r.types.dataTypes__Repository.map[transformType])
	}
	
	def create RepositoryFactory.eINSTANCE.createCompositeDataType transform(CompositeDataType d) {
		entityName = d.entityName
		parentType_CompositeDataType.addAll(d.parentType_CompositeDataType.map[transform])
		innerDeclaration_CompositeDataType.addAll(d.innerDeclaration_CompositeDataType.map[transform])
	}
	
	def create RepositoryFactory.eINSTANCE.createInnerDeclaration transform(InnerDeclaration d) {
		entityName = d.entityName
		datatype_InnerDeclaration = d.datatype_InnerDeclaration.transformType
	}
	
	def create RepositoryFactory.eINSTANCE.createCollectionDataType transform(CollectionDataType d) {
		entityName = d.entityName
		innerType_CollectionDataType = d.innerType_CollectionDataType.transformType
	}
	
	def DataType transformType(DataType d){
		switch d {
			PrimitiveDataType : d
			CollectionDataType : d.transform
			CompositeDataType : d.transform
		}
			
	}
	
	
	
	
	
	def create RepositoryFactory.eINSTANCE.createOperationInterface() transform(Interface c) {
		entityName = c.name
		signatures__OperationInterface.addAll(c.signature.map[transform])
	}
	
	def create RepositoryFactory.eINSTANCE.createOperationSignature() transform(Signature c) {
		entityName = c.name
		parameters__OperationSignature.addAll(c.parameters.map[transform])
	}
	
	def create RepositoryFactory.eINSTANCE.createParameter() transform(SignatureParameter s) {
		parameterName = s.name
		if(s.type instanceof PrimitiveDataType)
			dataType__Parameter = s.type
		else
			dataType__Parameter = s.type.transformType
	}
	
	
	def create RepositoryFactory.eINSTANCE.createBasicComponent() transform(Component c) {
		entityName = c.name
		requiredRoles_InterfaceRequiringEntity.addAll(c.requires.map[transformRequired])
		providedRoles_InterfaceProvidingEntity.addAll(c.provides.map[transformProvided])
		serviceEffectSpecifications__BasicComponent.addAll(c.seffs.map[transform])
		passiveResource_BasicComponent.addAll(c.passiveResources.map[transform])
	}
	
	def create RepositoryFactory.eINSTANCE.createOperationRequiredRole() transformRequired(RoleSpecification c) {
		entityName = c.name
		requiredInterface__OperationRequiredRole = transform(c.interface)
	}
	
	def create RepositoryFactory.eINSTANCE.createOperationProvidedRole() transformProvided(RoleSpecification c) {
		entityName = c.name
		providedInterface__OperationProvidedRole = transform(c.interface)
	}
	
	def create SeffFactory.eINSTANCE.createResourceDemandingSEFF transform(Seff s) {
		describedService__SEFF = s.signature.transform
		steps_Behaviour.addAll(s.actions.transformActions)
		
	}
	
	def Collection<? extends AbstractAction> transformActions(EList<SeffAction> list) {
		val it = new ArrayList<AbstractAction>()
		add(SeffFactory.eINSTANCE.createStartAction)
		addAll(list.map[transformAction])
		add(SeffFactory.eINSTANCE.createStopAction)

		it.forEach[action, i|
			if(i > 0)				
				action.predecessor_AbstractAction = get(i-1);
		] 
		return it		
	}
	
	def dispatch AbstractAction transformAction(SeffAction s) {
		throw new UnsupportedOperationException("TODO: auto-generated method stub")
	}
	
	def dispatch create SeffFactory.eINSTANCE.createInternalAction transformAction(SeffInternalAction s) {
		entityName = s.name
		resourceDemand_Action.add(s.transformDemand)
	}
	
	def ParametricResourceDemand transformDemand(SeffInternalAction action){
		val it = SeffPerformanceFactory.eINSTANCE.createParametricResourceDemand
		requiredResource_ParametricResourceDemand = action.demandType
		specification_ParametericResourceDemand = CoreFactory.eINSTANCE.createPCMRandomVariable()
		specification_ParametericResourceDemand.specification = action.demand
		return it
	}
	
	def dispatch create SeffFactory.eINSTANCE.createExternalCallAction transformAction(SeffExternalCallAction s) {
		entityName = s.name
		calledService_ExternalService = s.called.transform
		role_ExternalService = s.role.transformRequired
		inputVariableUsages__CallAction.addAll(s.bindings.map[transformParameter])
		returnVariableUsage__CallReturnAction.addAll(s.returning.map[transformParameter])
	}
	
	def create ParameterFactory.eINSTANCE.createVariableUsage transformParameter(SeffCallParameter p) {
		namedReference__VariableUsage = StoexFactory.eINSTANCE.createVariableReference
		if(p.parameter != null)
			namedReference__VariableUsage.referenceName = p.parameter.name
		else if(p.referenceName != null)			
			namedReference__VariableUsage.referenceName = p.referenceName
			
		variableCharacterisation_VariableUsage.addAll(p.values.map[transformCharacterisation])
	}
	
	def create ParameterFactory.eINSTANCE.createVariableUsage transformParameter(SeffReferenceParameter p) {
		namedReference__VariableUsage = StoexFactory.eINSTANCE.createVariableReference
		namedReference__VariableUsage.referenceName = p.referenceName
			
		variableCharacterisation_VariableUsage.addAll(p.values.map[transformCharacterisation])
	}
	
	def create ParameterFactory.eINSTANCE.createVariableCharacterisation transformCharacterisation(SeffVariableChar c) {
		type = c.characterisationType
		
		specification_VariableCharacterisation = CoreFactory.eINSTANCE.createPCMRandomVariable()
		specification_VariableCharacterisation.specification = c.value
		
	}
	
	
	def dispatch create SeffFactory.eINSTANCE.createBranchAction transformAction(SeffProbabilisticBranchAction s) {
		entityName = s.name
		branches_Branch.addAll(s.branches.map[transformBranch])
	}
	
	def create SeffFactory.eINSTANCE.createProbabilisticBranchTransition transformBranch(SeffProbabilisticBranch s) {
		entityName = s.name
		branchProbability = s.probability
		branchBehaviour_BranchTransition = s.seff.transform
	}
	
	
	
	def dispatch create SeffFactory.eINSTANCE.createBranchAction transformAction(SeffGuardedBranchAction s) {
		entityName = s.name
		branches_Branch.addAll(s.branches.map[transformBranch])
	}
	
	def create SeffFactory.eINSTANCE.createGuardedBranchTransition transformBranch(SeffGuardedBranch s) {
		branchCondition_GuardedBranchTransition = CoreFactory.eINSTANCE.createPCMRandomVariable()
		branchCondition_GuardedBranchTransition.specification = s.condition
		branchBehaviour_BranchTransition = s.seff.transform
	}
	
	def create SeffFactory.eINSTANCE.createResourceDemandingBehaviour transform(SubSeff s) {
		steps_Behaviour.addAll(s.actions.transformActions)
	}
	
	
	def dispatch create SeffFactory.eINSTANCE.createForkAction transformAction(SeffForkAction s) {
		entityName = s.name
		if(s.sync) {
			synchronisingBehaviours_ForkAction = SeffFactory.eINSTANCE.createSynchronisationPoint
			synchronisingBehaviours_ForkAction.synchronousForkedBehaviours_SynchronisationPoint.addAll(s.forks.map[transform])
		}
		else {
			asynchronousForkedBehaviours_ForkAction.addAll(s.forks.map[transform])	
		}
		
	}
	
	
	def create SeffFactory.eINSTANCE.createForkedBehaviour transform(SeffFork s) {
		steps_Behaviour.addAll(s.seff.actions.transformActions)
	}
	
	
	def dispatch create SeffFactory.eINSTANCE.createAcquireAction transformAction(SeffAcquireAction s) {
		entityName = s.name
		passiveresource_AcquireAction = s.resource.transform
	}
	
	def dispatch create SeffFactory.eINSTANCE.createReleaseAction transformAction(SeffReleaseAction s) {
		entityName = s.name
		passiveResource_ReleaseAction = s.resource.transform
	}

	def dispatch create SeffFactory.eINSTANCE.createLoopAction transformAction(SeffLoopAction s) {
		entityName = s.name
		iterationCount_LoopAction = CoreFactory.eINSTANCE.createPCMRandomVariable()
		iterationCount_LoopAction.specification = s.count
		bodyBehaviour_Loop = s.actions.transform
	}
	
	def dispatch create SeffFactory.eINSTANCE.createSetVariableAction transformAction(SeffSetReturnAction s) {
		entityName = s.name
		localVariableUsages_SetVariableAction.add(s.returnValue.transformParameter)
	}
	
	def create ParameterFactory.eINSTANCE.createVariableUsage transformParameter(SeffReturnParameter p) {
		namedReference__VariableUsage = StoexFactory.eINSTANCE.createVariableReference
		namedReference__VariableUsage.referenceName = "RETURN"
		variableCharacterisation_VariableUsage.addAll(p.values.map[transformCharacterisation])
	}
	
	def dispatch create SeffFactory.eINSTANCE.createSetVariableAction transformAction(SeffSetVariableAction s) {
		entityName = s.name
		localVariableUsages_SetVariableAction.addAll(s.setValues.map[transformParameter])
	}
	
	

	def create RepositoryFactory.eINSTANCE.createPassiveResource() transform(PassiveResource c) {
		entityName = c.name
		capacity_PassiveResource = CoreFactory.eINSTANCE.createPCMRandomVariable()
		capacity_PassiveResource.specification = Integer.toString(c.capacity)
	}
		
	
}
