package com.palladiosimulator.textual.repository.scoping;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class RepoLangImportURIGlobalScopeProvider extends ImportUriGlobalScopeProvider {
  private static final String TYPES_URI = "pathmap://PCM_MODELS/PrimitiveTypes.repository";

  private static final String RESOURCE_TYPES_URI = "pathmap://PCM_MODELS/Palladio.resourcetype";

  /**
   * /
   */
  @Override
  protected LinkedHashSet<URI> getImportedUris(final Resource resource) {
    final LinkedHashSet<URI> importedURIs = super.getImportedUris(resource);
    final Consumer<String> _function = (String it) -> {
      URI _createURI = URI.createURI(it);
      importedURIs.add(_createURI);
    };
    Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(RepoLangImportURIGlobalScopeProvider.TYPES_URI, RepoLangImportURIGlobalScopeProvider.RESOURCE_TYPES_URI)).forEach(_function);
    this.registerUriMappings(resource);
    return importedURIs;
  }

  protected Object registerUriMappings(final Resource resource) {
    return null;
  }
}
